"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../../services/base.service");
const category_entity_1 = require("./category.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const search_enum_1 = require("../../enums/search.enum");
let CategoryService = class CategoryService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.category);
        this.repo = repo;
        this.queryStruct = [
            { field: 'title', condition: search_enum_1.ESearchCondition.contains },
            { field: 'description', condition: search_enum_1.ESearchCondition.contains },
            {
                field: 'slug',
                condition: search_enum_1.ESearchCondition.equal,
                joinCondition: search_enum_1.ESearchJoinCondition.or,
            },
            { field: 'parentId', condition: search_enum_1.ESearchCondition.equal },
        ];
        this.deletionStyle = base_enum_1.EDeletionType.soft;
    }
    async _createChecks(data) {
        if (data.parentId)
            await this.checkIfExistsBy({ id: data.parentId }, { errorMessage: `Parent does not exist` });
        await this.checkIfUniqueBy({ parentId: data.parentId, slug: data.slug }, { errorMessage: `Slug ${data.slug} already exists` });
    }
    async _updateChecks(id, data) {
        if (data.parentId)
            await this.checkIfExistsBy({ id: data.parentId }, { errorMessage: `Parent does not exist` });
        await this.checkIfUniqueBy({ parentId: data.parentId, slug: data.slug, id: (0, typeorm_1.Not)(id) }, { errorMessage: `Slug ${data.slug} already exists` });
    }
    async _deleteChecks(ids) {
        await this.checkIfDeletable({ id: (0, typeorm_1.In)(ids) }, { relationField: 'children' });
    }
    getBySlug(query) {
        return this.repo.find({
            where: { slug: query.slug, parent: { slug: query.parentSlug } },
            select: {
                title: true,
                id: true,
                slug: true,
                description: true,
            },
        });
    }
};
exports.CategoryService = CategoryService;
exports.CategoryService = CategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(category_entity_1.CategoryEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], CategoryService);
//# sourceMappingURL=category.service.js.map