"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FAQService = exports.FAQGroupService = void 0;
const common_1 = require("@nestjs/common");
const base_service_1 = require("../../services/base.service");
const faq_entity_1 = require("./faq.entity");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const base_enum_1 = require("../../enums/base.enum");
const search_enum_1 = require("../../enums/search.enum");
const search_service_1 = require("../../services/search.service");
let FAQGroupService = class FAQGroupService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.faqGroups);
        this.repo = repo;
        this.queryStruct = [
            { field: 'name', condition: search_enum_1.ESearchCondition.contains },
            ...search_service_1.SearchService.refQueryStruct,
        ];
    }
    async getSingle(where, auth) {
        auth;
        return this.repo.findOne({
            where,
            relations: { creator: true },
        });
    }
};
exports.FAQGroupService = FAQGroupService;
exports.FAQGroupService = FAQGroupService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(faq_entity_1.FAQGroupEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository])
], FAQGroupService);
let FAQService = class FAQService extends base_service_1.BaseService {
    constructor(repo, groupService) {
        super(repo, base_enum_1.ETableName.faqs);
        this.repo = repo;
        this.groupService = groupService;
        this.queryStruct = [
            { field: 'title', condition: search_enum_1.ESearchCondition.contains },
            { field: 'content', condition: search_enum_1.ESearchCondition.contains },
            { field: 'link', condition: search_enum_1.ESearchCondition.contains },
            { field: 'groupId' },
            { field: 'parentId' },
            ...search_service_1.SearchService.refQueryStruct,
        ];
    }
    async getSingle(where, auth) {
        auth;
        if (typeof where.groupId == 'string')
            await this.groupService.checkIfExistsById(where.groupId, {
                errorMessage: `FAQ group does not exist`,
            });
        return this.repo.findOne({
            where,
            relations: { group: { creator: true }, creator: true },
        });
    }
    async _createChecks(data) {
        if (data.groupId)
            await this.groupService.checkIfExistsById(data.groupId, {
                errorMessage: `FAQ group does not exist`,
            });
        if (data.parentId)
            await this.checkIfExistsById(data.parentId, {
                errorMessage: `FAQ does not exist`,
            });
    }
    async _updateChecks(id, data) {
        if (data.groupId)
            await this.groupService.checkIfExistsById(data.groupId, {
                errorMessage: `FAQ group does not exist`,
            });
        if (data.parentId)
            await this.checkIfExistsById(data.parentId, {
                errorMessage: `FAQ does not exist`,
            });
    }
};
exports.FAQService = FAQService;
exports.FAQService = FAQService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(faq_entity_1.FAQEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        FAQGroupService])
], FAQService);
//# sourceMappingURL=faq.service.js.map