import { SaveFormFieldDTO, SearchFormFieldDTO, UpdateFormFieldDTO } from './form-field.dto';
import { IDDto } from '../../../dtos/base.dto';
import { IAuthParam } from '../../authentication/authentication.interface';
import { EInputType } from '../form-generator.enum';
import { BaseCRUDController } from '../../../controllers/base.controller';
import { FormFieldEntity } from '../form-generator.entity';
import { FormFieldService } from './form-field.service';
export declare class FormFieldController extends BaseCRUDController<FormFieldEntity, SearchFormFieldDTO> {
    protected service: FormFieldService;
    constructor(service: FormFieldService);
    create(body: SaveFormFieldDTO, auth: IAuthParam): string | Promise<FormFieldEntity>;
    updateByID(param: IDDto, body: UpdateFormFieldDTO, auth: IAuthParam): string | Promise<FormFieldEntity>;
    search(query: SearchFormFieldDTO): Promise<string | import("../../..").ISearchResponse<FormFieldEntity>>;
    getByID(param: IDDto): Promise<string | FormFieldEntity>;
    getInputTypes(): Promise<string | EInputType[]>;
}
