import { FindOptionsWhere, Repository } from 'typeorm';
import { FormEntity, FormFieldBankEntity, FormFieldEntity } from '../form-generator.entity';
import { BaseService } from '../../../services/base.service';
import { SaveFormFieldDTO, SearchFormFieldDTO, UpdateFormFieldDTO } from './form-field.dto';
import { FormFieldBankService } from '../form-field-bank/form-field-bank.service';
import { ICreateConfig } from '../../../interfaces/index.interface';
export declare class FormFieldService extends BaseService<FormFieldEntity, SearchFormFieldDTO> {
    protected repo: Repository<FormFieldEntity>;
    protected repoFormFieldBank: Repository<FormFieldBankEntity>;
    protected repoForm: Repository<FormEntity>;
    formFieldBankService: FormFieldBankService;
    constructor(repo: Repository<FormFieldEntity>, repoFormFieldBank: Repository<FormFieldBankEntity>, repoForm: Repository<FormEntity>, formFieldBankService: FormFieldBankService);
    getSingle(where: FindOptionsWhere<FormFieldEntity>): Promise<FormFieldEntity>;
    _create({ order, bankFieldID, formID, ...formBankBody }: SaveFormFieldDTO): Promise<FormFieldEntity>;
    _updateByID(id: string, { order, bankFieldID, updateBank, ...body }: UpdateFormFieldDTO, config?: ICreateConfig): Promise<FormFieldEntity>;
    protected handleFormQuery: <T extends SearchFormFieldDTO>({ hint, label, placeholder, ...restQuery }: T) => {
        customQuery: {
            hint: import("typeorm").FindOperator<string>;
            label: import("typeorm").FindOperator<string>;
            placeholder: import("typeorm").FindOperator<string>;
        };
        restQuery: Omit<T, "label" | "hint" | "placeholder">;
    };
    searchV2({ formName, formID, ...query }: SearchFormFieldDTO): Promise<import("../../..").ISearchResponse<FormFieldEntity>>;
    protected _checkIfBoundForms(formFieldIDs: string[]): Promise<void>;
    checkIfExternalBounds: (formFieldBankIDs: string[]) => Promise<any>;
    _deleteChecks(ids: string[]): Promise<void>;
}
