"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FormFieldService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const form_generator_entity_1 = require("../form-generator.entity");
const base_service_1 = require("../../../services/base.service");
const base_enum_1 = require("../../../enums/base.enum");
const utility_service_1 = require("../../../services/utility.service");
const form_field_bank_service_1 = require("../form-field-bank/form-field-bank.service");
let FormFieldService = class FormFieldService extends base_service_1.BaseService {
    constructor(repo, repoFormFieldBank, repoForm, formFieldBankService) {
        super(repo, base_enum_1.ETableName.formField);
        this.repo = repo;
        this.repoFormFieldBank = repoFormFieldBank;
        this.repoForm = repoForm;
        this.formFieldBankService = formFieldBankService;
        this.handleFormQuery = ({ hint, label, placeholder, ...restQuery }) => {
            return {
                customQuery: {
                    hint: hint ? (0, typeorm_2.Like)(`%${hint}%`) : null,
                    label: label ? (0, typeorm_2.Like)(`%${label}%`) : null,
                    placeholder: placeholder ? (0, typeorm_2.Like)(`%${placeholder}%`) : null,
                },
                restQuery,
            };
        };
    }
    getSingle(where) {
        return this.repo.findOne({
            where,
            relations: { baseField: true, form: true },
        });
    }
    async _create({ order, bankFieldID, formID, ...formBankBody }) {
        if (formID) {
            const exists = await this.repoForm.exist({
                where: { id: formID },
            });
            if (!exists)
                utility_service_1.UtilityClass.throwError({
                    message: 'Form could not be found',
                    statusCode: 404,
                });
        }
        delete formBankBody['id'];
        const fieldBank = await (bankFieldID
            ? this.formFieldBankService.getById(bankFieldID)
            : this.formFieldBankService._create(formBankBody));
        if (!fieldBank)
            utility_service_1.UtilityClass.throwError({
                message: 'Form Field could not be found in the bank',
                statusCode: 404,
            });
        delete fieldBank.formFields;
        const { id } = await this.repo.save(new form_generator_entity_1.FormFieldEntity({
            baseField: fieldBank,
            formId: formID,
            order,
        }));
        return this.getById(id);
    }
    async _updateByID(id, { order, bankFieldID, updateBank, ...body }, config) {
        const existing = await this.repo.findOne({
            where: { id },
            select: { id: true, baseField: { id: true } },
            relations: { baseField: true },
        });
        if (!existing)
            utility_service_1.UtilityClass.throwError({
                message: 'Form Field could not be found',
                statusCode: 404,
            });
        if (existing.baseField?.id && !bankFieldID && updateBank) {
            await this.formFieldBankService._updateByID(existing.baseField.id, body, {
                ...config,
                returnItem: false,
            });
            await this.repo.update({ id }, { order });
        }
        else if (bankFieldID) {
            const fieldBank = await this.repoFormFieldBank.exist({
                where: { id: bankFieldID },
            });
            if (!fieldBank)
                utility_service_1.UtilityClass.throwError({
                    message: 'Form Field could not be found in the bank',
                    statusCode: 404,
                });
            await this.repo.update({ id }, { order, baseFieldId: bankFieldID });
        }
        else {
            const baseField = await this.formFieldBankService._create(body, { ...config, returnItem: false });
            delete baseField.field;
            await this.repo.update({ id }, { order, baseField });
        }
        return this.getById(id);
    }
    searchV2({ formName, formID, ...query }) {
        const { restQuery, customQuery } = this.handleFormQuery(query);
        return utility_service_1.UtilityClass.search(this.repo, restQuery, {
            baseOrder: { createdAt: 'DESC' },
            baseWhere: {
                form: { name: formName ? (0, typeorm_2.Like)(`%${formName}%`) : null, id: formID },
                ...customQuery,
            },
            baseRelations: { baseField: true, form: !!formName },
        });
    }
    async _checkIfBoundForms(formFieldIDs) {
        if (await this.repoForm.exist({
            where: { fields: { id: (0, typeorm_2.In)(formFieldIDs) } },
        }))
            utility_service_1.UtilityClass.throwError({
                statusCode: 400,
                message: `Forms are using this item`,
            });
    }
    async _deleteChecks(ids) {
        await Promise.all([
            this._checkIfBoundForms(ids),
            this.checkIfExternalBounds?.(ids),
        ]);
    }
};
exports.FormFieldService = FormFieldService;
exports.FormFieldService = FormFieldService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(form_generator_entity_1.FormFieldEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(form_generator_entity_1.FormFieldBankEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(form_generator_entity_1.FormEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        form_field_bank_service_1.FormFieldBankService])
], FormFieldService);
//# sourceMappingURL=form-field.service.js.map