import { SaveFormDTO, SearchFormDTO, UpdateFormDTO } from './form.dto';
import { IDDto } from '../../../dtos/base.dto';
import { FormService } from './form.service';
import { IAuthParam } from '../../authentication/authentication.interface';
import { BaseCRUDController } from '../../../controllers/base.controller';
import { FormEntity } from '../form-generator.entity';
export declare class FormController extends BaseCRUDController<FormEntity, SearchFormDTO> {
    protected service: FormService;
    constructor(service: FormService);
    create(body: SaveFormDTO, auth: IAuthParam): string | Promise<FormEntity>;
    editForm(param: IDDto, body: UpdateFormDTO, auth: IAuthParam): Promise<string | FormEntity>;
    search(query: SearchFormDTO): Promise<string | import("../../..").ISearchResponse<FormEntity>>;
}
