import { FindOptionsWhere, Repository } from 'typeorm';
import { FormEntity } from '../form-generator.entity';
import { SaveFormDTO, SearchFormDTO, UpdateFormDTO } from './form.dto';
import { BaseService } from '../../../services/base.service';
import { FormFieldService } from '../form-field/form-field.service';
import { FormGeneratorService } from '../form-generator.service';
import { ICreateConfig } from '../../../interfaces/index.interface';
export declare class FormService extends BaseService<FormEntity, SearchFormDTO> {
    protected repo: Repository<FormEntity>;
    formFieldService: FormFieldService;
    formGeneratorService: FormGeneratorService;
    constructor(repo: Repository<FormEntity>, formFieldService: FormFieldService, formGeneratorService: FormGeneratorService);
    getSingle(where: FindOptionsWhere<FormEntity>): Promise<FormEntity>;
    _create({ fieldBankIDs, fields, ...data }: SaveFormDTO, config?: ICreateConfig): Promise<FormEntity>;
    _updateByID(id: string, { fieldBankIDs, fields, replaceAllFields, ...data }: UpdateFormDTO, config?: {
        returnItem?: boolean;
    }): Promise<FormEntity>;
    _deleteByID(id: string): Promise<import("typeorm").DeleteResult>;
    _deleteByIDs(ids: string[]): Promise<import("typeorm").DeleteResult>;
}
