import { ListOptionsEntity, ListsEntity } from './lists.entity';
import { Repository } from 'typeorm';
import { SaveListGroupDTO } from './lists.dto';
import { RoutePath } from '../../classes/route-path.class';
export declare const ListsRoutePath: RoutePath;
export declare class ListsService {
    protected repo: Repository<ListsEntity>;
    protected repoOptions: Repository<ListOptionsEntity>;
    constructor(repo: Repository<ListsEntity>, repoOptions: Repository<ListOptionsEntity>);
    getAll(): Promise<ListsEntity[]>;
    getAllGroupsOnly(): Promise<ListsEntity[]>;
    getGroupByID(id: string): Promise<ListsEntity>;
    getSingleByValue(value: string): Promise<ListsEntity>;
    getOptionsByGroupValue(value: string): Promise<ListOptionsEntity[]>;
    createSingle(data: SaveListGroupDTO): Promise<ListsEntity>;
    updateSingle(id: string, { options, ...data }: SaveListGroupDTO): Promise<ListsEntity>;
    deleteSingle(id: string): Promise<[import("typeorm").DeleteResult, import("typeorm").DeleteResult]>;
}
