"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var EndpointLoggingInterceptor_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointLoggingInterceptor = void 0;
const common_1 = require("@nestjs/common");
const operators_1 = require("rxjs/operators");
const endpoint_logger_db_service_1 = require("./endpoint-logger-db.service");
const core_1 = require("@nestjs/core");
let EndpointLoggingInterceptor = EndpointLoggingInterceptor_1 = class EndpointLoggingInterceptor {
    constructor(endpointLoggerService) {
        this.endpointLoggerService = endpointLoggerService;
    }
    async intercept(context, next) {
        // debugger;
        const req = context.getArgByIndex(0);
        if (await this.endpointLoggerService.skipCondition?.(req?.['user']))
            return next.handle();
        const log = {
            endpoint: req?.originalUrl || 'test',
            inDateTime: new Date().getTime(),
            creatorId: req?.['user']?.id,
            method: req?.method,
        };
        return next.handle().pipe((0, operators_1.tap)(() => this.endpointLoggerService._create({
            ...log,
            outDateTime: new Date().getTime(),
            isError: false,
        })), (0, operators_1.catchError)((e) => {
            this.endpointLoggerService._create({
                ...log,
                outDateTime: new Date().getTime(),
                isError: true,
            });
            throw e;
        }));
    }
    static provideInterceptor() {
        return {
            provide: core_1.APP_INTERCEPTOR,
            useClass: EndpointLoggingInterceptor_1,
        };
    }
};
exports.EndpointLoggingInterceptor = EndpointLoggingInterceptor;
exports.EndpointLoggingInterceptor = EndpointLoggingInterceptor = EndpointLoggingInterceptor_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [endpoint_logger_db_service_1.EndpointLoggerService])
], EndpointLoggingInterceptor);
//# sourceMappingURL=endpoint-logger.interceptor.js.map