import { BaseController } from '../../controllers/base.controller';
import { LoggerDBEntity } from './logger-db.entity';
import { LoggerDBService } from './logger-db.service';
import { LoggerDBSearchDTO, SearchEndpointLoggerSearchDTO } from './logger-db.dto';
import { IAuthParam } from '../authentication/authentication.interface';
import { EndpointLoggerService } from './endpoint-logger-db.service';
export declare class LoggerDBController extends BaseController<LoggerDBEntity, LoggerDBSearchDTO> {
    protected readonly service: LoggerDBService;
    endpointLoggerService: EndpointLoggerService;
    constructor(service: LoggerDBService, endpointLoggerService: EndpointLoggerService);
    search(query: LoggerDBSearchDTO, auth?: IAuthParam): Promise<string | import("../..").ISearchResponse<LoggerDBEntity>>;
    searchEndpoint(query: SearchEndpointLoggerSearchDTO, auth?: IAuthParam): Promise<string | import("../..").ISearchResponse<LoggerDBEntity>>;
}
