"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerDBController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("../../controllers/base.controller");
const logger_db_service_1 = require("./logger-db.service");
const logger_db_dto_1 = require("./logger-db.dto");
const authentication_guard_1 = require("../authentication/authentication.guard");
const endpoint_logger_db_service_1 = require("./endpoint-logger-db.service");
let LoggerDBController = class LoggerDBController extends base_controller_1.BaseController {
    constructor(service, endpointLoggerService) {
        super(service);
        this.service = service;
        this.endpointLoggerService = endpointLoggerService;
    }
    async search(query, auth) {
        return super.search(query, auth, this.service.searchV2);
    }
    async searchEndpoint(query, auth) {
        return super.search(query, auth, this.endpointLoggerService.searchV2);
    }
};
exports.LoggerDBController = LoggerDBController;
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Search logs', description: 'Search and filter logs based on provided criteria' }),
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [logger_db_dto_1.LoggerDBSearchDTO, Object]),
    __metadata("design:returntype", Promise)
], LoggerDBController.prototype, "search", null);
__decorate([
    (0, swagger_1.ApiOperation)({ summary: 'Search endpoint logs', description: 'Search and filter endpoint-specific logs' }),
    (0, common_1.Get)('search/endpoint'),
    __param(0, (0, common_1.Query)()),
    __param(1, (0, authentication_guard_1.AuthParam)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [logger_db_dto_1.SearchEndpointLoggerSearchDTO, Object]),
    __metadata("design:returntype", Promise)
], LoggerDBController.prototype, "searchEndpoint", null);
exports.LoggerDBController = LoggerDBController = __decorate([
    (0, swagger_1.ApiTags)(logger_db_service_1.LoggerDBService.tag),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Controller)({
        //   version: '1',
        path: logger_db_service_1.LoggerDBService.path,
    }),
    __metadata("design:paramtypes", [logger_db_service_1.LoggerDBService,
        endpoint_logger_db_service_1.EndpointLoggerService])
], LoggerDBController);
//# sourceMappingURL=logger-db.controller.js.map