"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogsController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("../../controllers/base.controller");
const logs_service_1 = require("./logs.service");
const utility_service_1 = require("../../services/utility.service");
const logs_dto_1 = require("./logs.dto");
let LogsController = class LogsController extends base_controller_1.BaseController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async create(body) {
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.service._create(body),
        });
    }
    async multiple(body) {
        return utility_service_1.UtilityClass.handleSuccess({
            data: await this.service.createMultiple(body),
        });
    }
    async search(query) {
        // debugger;
        return super.search(query);
    }
};
exports.LogsController = LogsController;
__decorate([
    (0, common_1.Post)('single'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [logs_dto_1.LogCreateSingleDTO]),
    __metadata("design:returntype", Promise)
], LogsController.prototype, "create", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [logs_dto_1.LogCreateMultipleDTO]),
    __metadata("design:returntype", Promise)
], LogsController.prototype, "multiple", null);
__decorate([
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [logs_dto_1.LogSearchDTO]),
    __metadata("design:returntype", Promise)
], LogsController.prototype, "search", null);
exports.LogsController = LogsController = __decorate([
    (0, swagger_1.ApiTags)(logs_service_1.LogsService.tag),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Controller)({
        //   version: '1',
        path: logs_service_1.LogsService.path,
    }),
    __metadata("design:paramtypes", [logs_service_1.LogsService])
], LogsController);
//# sourceMappingURL=logs.controller.js.map