import { BaseDto } from '../../dtos/base.dto';
import { LogEntity } from './logs.entity';
import { SearchQueryDto } from '../../dtos/search.dto';
export declare class LogCreateSingleDTO extends BaseDto implements Partial<LogEntity> {
    category?: string;
    ipAddress?: string;
    macAddress?: string;
    message?: string;
    meta?: object;
    origin?: string;
    refCat?: string;
    refNo?: string;
}
declare class LogCreateForMultipleDTO extends LogCreateSingleDTO implements Partial<LogEntity> {
    createdAt: string;
}
export declare class LogCreateMultipleDTO {
    logs: LogCreateForMultipleDTO[];
}
export declare class LogSearchDTO extends SearchQueryDto<LogSearchDTO> implements Partial<LogEntity> {
    category?: string;
    ipAddress?: string;
    macAddress?: string;
    message?: string;
    origin?: string;
    refCat?: string;
    refNo?: string;
    device?: string;
    browser?: string;
    os?: string;
}
export type ILogBase = Partial<LogEntity>;
export {};
