"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogsForInterceptorService = exports.LogsService = void 0;
const common_1 = require("@nestjs/common");
const logs_entity_1 = require("./logs.entity");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const search_enum_1 = require("../../enums/search.enum");
const UAParser = require("ua-parser-js");
const core_1 = require("@nestjs/core");
let LogsService = class LogsService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.logs);
        this.repo = repo;
        this.queryStruct = [
            { field: 'refCat' },
            { field: 'refNo' },
            { field: 'message', condition: search_enum_1.ESearchCondition.contains },
            { field: 'category' },
            { field: 'ipAddress' },
            { field: 'macAddress' },
            { field: 'origin' },
            { field: 'device', condition: search_enum_1.ESearchCondition.contains },
            { field: 'browser', condition: search_enum_1.ESearchCondition.contains },
            { field: 'os', condition: search_enum_1.ESearchCondition.contains },
        ];
        // this.queryStruct = [];
    }
    static parseHeader(request) {
        if (!request)
            return null;
        // console.log(headers);
        const res = new UAParser(request.headers['user-agent']), { browser, os, device } = res.getResult();
        return {
            browser: ((browser?.name || '') + ' ' + (browser?.version || '')).trim(),
            os: ((os?.name || '') + ' ' + (os?.version || '')).trim(),
            device: ((device?.model || '') +
                ' ' +
                (device?.type || '') +
                ' ' +
                (device?.vendor || '')).trim(),
            origin: request.headers['host'],
            ipAddress: request.ip,
        };
    }
    _create(data) {
        delete data['id'];
        return super._create({ ...data });
    }
    async createMultiple(logs) {
        // const headerData = this.parseHeader(headers);
        await Promise.all(logs.logs.map((x) => this._create(x)));
        return { message: `Saved` };
    }
};
exports.LogsService = LogsService;
LogsService.path = 'logs';
exports.LogsService = LogsService = __decorate([
    (0, common_1.Injectable)({}),
    __param(0, (0, typeorm_1.InjectRepository)(logs_entity_1.LogEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], LogsService);
let LogsForInterceptorService = class LogsForInterceptorService extends LogsService {
    constructor(request, repo) {
        super(repo);
        this.request = request;
        this.repo = repo;
    }
    _create(data) {
        return super._create({ ...data, ...LogsService.parseHeader(this.request) });
    }
};
exports.LogsForInterceptorService = LogsForInterceptorService;
exports.LogsForInterceptorService = LogsForInterceptorService = __decorate([
    (0, common_1.Injectable)({ scope: common_1.Scope.REQUEST }),
    __param(0, (0, common_1.Inject)(core_1.REQUEST)),
    __param(1, (0, typeorm_1.InjectRepository)(logs_entity_1.LogEntity)),
    __metadata("design:paramtypes", [Object, typeorm_2.Repository])
], LogsForInterceptorService);
//# sourceMappingURL=logs.service.js.map