"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const base_controller_1 = require("../../controllers/base.controller");
const messages_service_1 = require("./messages.service");
const utility_service_1 = require("../../services/utility.service");
const messages_dto_1 = require("./messages.dto");
let MessageController = class MessageController extends base_controller_1.BaseController {
    constructor(service) {
        super(service);
        this.service = service;
    }
    async create(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.create(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async multiple(body) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.createMultiple(body),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query) {
        return super.search(query);
    }
};
exports.MessageController = MessageController;
__decorate([
    (0, common_1.Post)(''),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [messages_dto_1.CreateMessageDTO]),
    __metadata("design:returntype", Promise)
], MessageController.prototype, "create", null);
__decorate([
    (0, common_1.Post)('batch'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [messages_dto_1.CreateBatchMessagesDTO]),
    __metadata("design:returntype", Promise)
], MessageController.prototype, "multiple", null);
__decorate([
    (0, common_1.Get)('search'),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [messages_dto_1.MessageSearchDTO]),
    __metadata("design:returntype", Promise)
], MessageController.prototype, "search", null);
exports.MessageController = MessageController = __decorate([
    (0, swagger_1.ApiTags)(messages_service_1.MessageService.tag),
    (0, swagger_1.ApiBearerAuth)(),
    (0, common_1.Controller)({
        path: messages_service_1.MessageService.path,
    }),
    __metadata("design:paramtypes", [messages_service_1.MessageService])
], MessageController);
//# sourceMappingURL=messages.controller.js.map