import { MessageEntity } from './messages.entity';
import { SearchQueryDto } from '../../dtos/search.dto';
import { BaseDto } from '../../dtos/base.dto';
import { EMessageStatus, EMessageType } from './messages.enum';
export declare class CreateMessageDTO extends BaseDto implements Partial<MessageEntity> {
    message: string;
    receiverIDs: string[];
    subject?: string;
    type?: EMessageType;
    isHTML?: boolean;
    sender?: string;
    refID?: string;
    refCat?: string;
}
export declare class CreateBatchMessagesDTO {
    messages: CreateMessageDTO[];
}
export declare class MessageSearchDTO extends SearchQueryDto implements Partial<MessageEntity> {
    recipients?: any;
    recipient?: string;
    sender?: string;
    message?: string;
    refCat?: string;
    refID?: string;
    status?: EMessageStatus;
}
