import { BaseEntity } from '../../entities/base.entity';
import { EMessageStatus, EMessageType } from './messages.enum';
export declare class MessageEntity extends BaseEntity {
    type: EMessageType;
    message: string;
    isHTML: boolean;
    subject?: string;
    sender?: string;
    refCat?: string;
    refID?: string;
    receiverIDs?: string[];
    recipientCount: number;
    status: EMessageStatus;
    recipients: MessageRecipientEntity[];
}
export declare class MessageRecipientEntity extends BaseEntity {
    status: EMessageStatus;
    recipient: string;
    response?: any;
    error?: any;
    message: MessageEntity;
}
export declare const messageEntities: (typeof MessageEntity | typeof MessageRecipientEntity)[];
