import { NotificationItemService, NotificationService } from './notification.service';
import { NotificationEntity } from './notification.entity';
import { CreateNotificationDTO, NotificationQueryDTO, NotificationToggleActiveStatusDTO } from './notification.dto';
import { BaseController } from '../../controllers/base.controller';
import { IAuthParam } from '../authentication/authentication.interface';
import { SearchQueryDto } from '../../dtos/search.dto';
import { IDDto } from '../../dtos/base.dto';
export declare class NotificationController extends BaseController<NotificationEntity, NotificationQueryDTO> {
    protected service: NotificationService;
    protected itemService: NotificationItemService;
    constructor(service: NotificationService, itemService: NotificationItemService);
    create(body: CreateNotificationDTO, auth: IAuthParam): Promise<string | NotificationEntity>;
    search(query: NotificationQueryDTO): Promise<string | import("../..").ISearchResponse<NotificationEntity>>;
    getMySentNotifications(query: SearchQueryDto, auth: IAuthParam): Promise<string | import("../..").ISearchResponse<NotificationEntity>>;
    getMyUnreadNotificationsCount(auth: IAuthParam): Promise<string | {
        count: number;
    }>;
    getMyRecievedNotifications(query: SearchQueryDto, auth: IAuthParam): Promise<string | import("../..").ISearchResponse<import("./notification.entity").NotificationItemEntity>>;
    toggleStatus(body: NotificationToggleActiveStatusDTO, auth: IAuthParam, param: IDDto): Promise<string | NotificationEntity>;
    resend(auth: IAuthParam, param: IDDto): Promise<string | NotificationEntity>;
    markAsRead(auth: IAuthParam, param: IDDto): Promise<string | import("./notification.entity").NotificationItemEntity>;
}
