import { Repository } from 'typeorm';
import { NotificationEntity, NotificationItemEntity } from './notification.entity';
import { CreateNotificationDTO, NotificationItemQueryDTO, NotificationQueryDTO, NotificationToggleActiveStatusDTO } from './notification.dto';
import { BaseService } from '../../services/base.service';
import { IAuthParam } from '../authentication/authentication.interface';
import { IDDto } from '../../dtos/base.dto';
import { SearchQueryDto } from '../../dtos/search.dto';
export declare class NotificationService extends BaseService<NotificationEntity, NotificationQueryDTO> {
    protected readonly repo: Repository<NotificationEntity>;
    protected readonly repoChild: Repository<NotificationItemEntity>;
    static path: string;
    constructor(repo: Repository<NotificationEntity>, repoChild: Repository<NotificationItemEntity>);
    create(data: CreateNotificationDTO): Promise<NotificationEntity>;
    toManagerFunc: (refCat: string, notification: NotificationEntity) => Promise<string[]>;
    toReceiverIDsFunc: (receiverIDs: string[], notification: NotificationEntity) => Promise<string[]>;
    toRefCatFunc: (refCat: string, notification: NotificationEntity) => Promise<string[]>;
    toAllFunc: (notification: NotificationEntity) => Promise<string[]>;
    protected send(notification: NotificationEntity): Promise<NotificationEntity>;
    resend(notificationID: string, auth: IAuthParam): Promise<NotificationEntity>;
    update(id: string, data: Partial<NotificationEntity>): Promise<NotificationEntity>;
    toggleActiveStatus(notificationID: IDDto, payload: NotificationToggleActiveStatusDTO): Promise<NotificationEntity>;
    getMySentNotifications(authID: string, query: SearchQueryDto): Promise<import("../..").ISearchResponse<NotificationEntity>>;
    getMyUnreadNotificationsCount(authID: string): Promise<{
        count: number;
    }>;
    calculateSeen(notificationID: string): Promise<import("typeorm").UpdateResult>;
}
export declare class NotificationItemService extends BaseService<NotificationItemEntity, NotificationItemQueryDTO> {
    protected readonly repo: Repository<NotificationItemEntity>;
    protected readonly repoParent: Repository<NotificationEntity>;
    static path: string;
    constructor(repo: Repository<NotificationItemEntity>, repoParent: Repository<NotificationEntity>);
    getById(id: string): Promise<NotificationItemEntity>;
    getMyReceivedNotifications(authID: string, query: SearchQueryDto): Promise<import("../..").ISearchResponse<NotificationItemEntity>>;
    markAsRead(itemID: IDDto, authID: string): Promise<NotificationItemEntity>;
}
