"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationItemService = exports.NotificationService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("typeorm");
const typeorm_2 = require("@nestjs/typeorm");
const notification_entity_1 = require("./notification.entity");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const utility_service_1 = require("../../services/utility.service");
const search_enum_1 = require("../../enums/search.enum");
let NotificationService = class NotificationService extends base_service_1.BaseService {
    constructor(repo, repoChild) {
        super(repo, base_enum_1.ETableName.notification);
        this.repo = repo;
        this.repoChild = repoChild;
        this.queryStruct = [
            { field: 'active' },
            { field: 'refCat' },
            { field: 'seen' },
            { field: 'sender' },
        ];
    }
    async create(data) {
        const item = Object.assign(new notification_entity_1.NotificationEntity(), data);
        delete item.id;
        if (data.receiverIDs?.length)
            item.meta = { receivers: data.receiverIDs };
        item.sender = item.sender || `System`;
        const res = await super._create(item);
        return await this.send(res);
    }
    async send(notification) {
        await this.repo.manager.transaction(async (transactionalEntityManager) => {
            let authIDs;
            if (notification.toManager)
                authIDs = await this.toManagerFunc(notification.refCat, notification);
            else if (notification.receiverIDs?.length)
                authIDs = await this.toReceiverIDsFunc(notification.receiverIDs, notification);
            else if (notification.refCat)
                authIDs = await this.toRefCatFunc(notification.refCat, notification);
            else
                authIDs = await this.toAllFunc(notification);
            await transactionalEntityManager.save(authIDs.map((id) => {
                const status = Object.assign(new notification_entity_1.NotificationItemEntity(), {});
                status.notification = notification;
                status.creator = { id };
                return status;
            }));
            await transactionalEntityManager.update(notification_entity_1.NotificationEntity, { id: notification.id }, {
                recipientCount: authIDs?.length,
                updater: notification.updater,
            });
        });
        return this.getById(notification.id);
    }
    async resend(notificationID, auth) {
        if (!(await this.checkIfExistsById(notificationID)))
            utility_service_1.UtilityClass.throwError({ message: `Id not found` });
        await this.repoChild.delete({ notification: { id: notificationID } });
        const notification = await this.repo.findOne({
            where: { id: notificationID },
        });
        notification.updater = auth;
        return await this.send(notification);
    }
    async update(id, data) {
        return super._updateByID(id, data);
    }
    async toggleActiveStatus(notificationID, payload) {
        await this.repo.manager.transaction(async (transactionalEntityManager) => {
            await transactionalEntityManager.update(notification_entity_1.NotificationEntity, { id: notificationID.id }, { active: payload.active, updater: payload.updater });
            await transactionalEntityManager.update(notification_entity_1.NotificationItemEntity, {
                notification: { id: notificationID.id },
            }, { active: payload.active, updater: payload.updater });
        });
        return this.getById(notificationID.id);
    }
    async getMySentNotifications(authID, query) {
        return this.search({ ...query, creatorId: authID });
    }
    async getMyUnreadNotificationsCount(authID) {
        return {
            count: await this.repoChild.count({
                where: {
                    creator: { id: authID },
                    seen: false,
                },
            }),
        };
    }
    async calculateSeen(notificationID) {
        const rCount = await this.repoChild.count({
            where: {
                notification: { id: notificationID },
            },
        });
        const sCount = await this.repoChild.count({
            where: {
                notification: { id: notificationID },
                seen: true,
            },
        });
        return this.repo.update({ id: notificationID }, {
            seen: rCount == sCount,
            recipientCount: rCount,
            seenCount: sCount,
        });
    }
};
exports.NotificationService = NotificationService;
NotificationService.path = `notification`;
exports.NotificationService = NotificationService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(notification_entity_1.NotificationEntity)),
    __param(1, (0, typeorm_2.InjectRepository)(notification_entity_1.NotificationItemEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository])
], NotificationService);
let NotificationItemService = class NotificationItemService extends base_service_1.BaseService {
    constructor(repo, repoParent) {
        super(repo, base_enum_1.ETableName.notificationStatus);
        this.repo = repo;
        this.repoParent = repoParent;
        this.queryStruct = [
            { field: 'active' },
            { field: 'seen' },
            {
                field: 'notification',
                condition: search_enum_1.ESearchCondition.leftJoin,
                tableAlias: base_enum_1.ETableName.notification,
            },
        ];
    }
    getById(id) {
        return this.repo.findOne({
            where: { id },
            relations: { notification: true },
        });
    }
    async getMyReceivedNotifications(authID, query) {
        return this.search({ ...query, creatorId: authID, active: true });
    }
    async markAsRead(itemID, authID) {
        return this._updateByID(itemID.id, utility_service_1.UtilityClass.patchUpdater({ seen: true }, {
            id: authID,
        }));
    }
};
exports.NotificationItemService = NotificationItemService;
NotificationItemService.path = `notification`;
exports.NotificationItemService = NotificationItemService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_2.InjectRepository)(notification_entity_1.NotificationItemEntity)),
    __param(1, (0, typeorm_2.InjectRepository)(notification_entity_1.NotificationEntity)),
    __metadata("design:paramtypes", [typeorm_1.Repository,
        typeorm_1.Repository])
], NotificationItemService);
//# sourceMappingURL=notification.service.js.map