import { PricingService } from './pricing.service';
import { BaseCRUDController } from '../../controllers/base.controller';
import { PricingEntity } from './pricing.entity';
import { CreatePricingDTO, SearchPricingDTO, UpdatePricingDTO } from './pricing.dto';
import { IAuthParam } from '../authentication/authentication.interface';
import { IDDto } from '../../dtos/base.dto';
export declare class PricingController extends BaseCRUDController<PricingEntity, SearchPricingDTO> {
    protected readonly service: PricingService;
    constructor(service: PricingService);
    create(body: CreatePricingDTO, auth: IAuthParam): string | Promise<PricingEntity<any>>;
    search(query: SearchPricingDTO, auth?: IAuthParam): Promise<string | import("../..").ISearchResponse<PricingEntity<any>>>;
    updateByID(param: IDDto, body: UpdatePricingDTO, auth: IAuthParam): string | Promise<PricingEntity<any>>;
}
