"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TelnetService = void 0;
const common_1 = require("@nestjs/common");
const net = require("net");
const telnet_stream_1 = require("telnet-stream");
const utility_service_1 = require("../../services/utility.service");
let TelnetService = class TelnetService {
    constructor() {
        this.pings = {};
        this.keyGen = (query) => `${query.url}:${query.port}`;
    }
    ping(query) {
        return new Promise((res) => {
            // Initialize the socket with the our ip and port
            const socket = net.createConnection(+query.port, query.url);
            const key = this.keyGen(query);
            // Connect the socket with telnet
            this.pings[key] = new telnet_stream_1.TelnetSocket(socket);
            // If the connection are close "close handler"
            this.pings[key].on('close', (hadError) => {
                console.log(key, 'on close', hadError);
                res({ error: hadError, e: 'Closed' });
            });
            this.pings[key].on('connect', () => {
                console.log(key, 'on connect');
                res({ connected: true });
            });
            this.pings[key].on('error', (e) => {
                console.log(key, 'on error', e);
                res({ error: true, e });
            });
            // If the connection are on "on handler"
            this.pings[key].on('data', (buffer) => {
                console.log(key, 'on stdout data');
                return process.stdout.write(buffer.toString('utf8'));
            });
            // If the connection are occurred something "doing handler"
            this.pings[key].on('do', (option) => {
                console.log(key, 'on do');
                return this.pings[key].writeWont(option);
            });
            this.pings[key].on('will', (option) => {
                console.log(key, 'on will');
                return this.pings[key].writeDont(option);
            });
            // If the connection are send the data "data handler"
            process.stdin.on('data', (buffer) => {
                console.log(key, 'on stdin data');
                return this.pings[key].write(buffer.toString('utf8'));
            });
        });
    }
    stop(query) {
        const key = this.keyGen(query);
        const sock = this.pings[key];
        if (!sock)
            utility_service_1.UtilityClass.throwError({
                message: `${query.url} ${query.port} does not exist in the cache`,
            });
        sock.destroy();
        delete this.pings[key];
    }
    clearAll() {
        this.pings = {};
    }
    get status() {
        return Object.entries(this.pings).map(([url, socket]) => {
            const status = {}, ref = socket.ref();
            for (const key in ref)
                if (Object.prototype.hasOwnProperty.call(ref, key))
                    if (key[0] != '_')
                        status[key] = ref[key];
            status['readable'] = ref.readable;
            status['readable'] = ref.pending;
            status['readable'] = ref.destroyed;
            status['autoSelectFamilyAttemptedAddresses'] =
                ref.autoSelectFamilyAttemptedAddresses;
            status['bufferSize'] = ref.bufferSize;
            status['bytesRead'] = ref.bytesRead;
            status['bytesWritten'] = ref.bytesWritten;
            status['localAddress'] = ref.localAddress;
            status['localPort'] = ref.localPort;
            status['localFamily'] = ref.localFamily;
            status['readyState'] = ref.readyState;
            status['remoteAddress'] = ref.remoteAddress;
            status['remoteFamily'] = ref.remoteFamily;
            status['remotePort'] = ref.remotePort;
            status['timeout'] = ref.timeout;
            return {
                url,
                socket: { address: socket.address(), status },
            };
        });
    }
};
exports.TelnetService = TelnetService;
exports.TelnetService = TelnetService = __decorate([
    (0, common_1.Injectable)()
], TelnetService);
//# sourceMappingURL=telnet.service.js.map