"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletTransactionController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const wallet_dto_1 = require("./wallet.dto");
const base_dto_1 = require("../../dtos/base.dto");
const utility_service_1 = require("../../services/utility.service");
const wallet_transaction_service_1 = require("./wallet-transaction.service");
const wallet_service_1 = require("./wallet.service");
let WalletTransactionController = class WalletTransactionController {
    constructor(service) {
        this.service = service;
    }
    // @Post(':id')
    // async create(
    //   @Body() data: CreateWalletTransactionDTO,
    //   @Param() param: IDDto,
    // ) {
    //   try {
    //     return UtilityClass.handleSuccess({
    //       data: await this.service.create(param.id, data),
    //     });
    //   } catch (error) {
    //     return UtilityClass.handleError(error);
    //   }
    // }
    // @Put(':id')
    // async update(
    //   @Body() data: UpdateWalletTransactionDTO,
    //   @Param() param: IDDto,
    // ) {
    //   try {
    //     return UtilityClass.handleSuccess({
    //       data: await this.service._updateByID(param.id, data),
    //     });
    //   } catch (error) {
    //     return UtilityClass.handleError(error);
    //   }
    // }
    async getByID(param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getById(param.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async search(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.search(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.WalletTransactionController = WalletTransactionController;
__decorate([
    (0, common_1.Get)('getByID/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get wallet transaction by ID', description: 'Retrieves a specific wallet transaction using its unique identifier' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], WalletTransactionController.prototype, "getByID", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Search wallet transactions', description: 'Search for wallet transactions based on provided criteria' }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wallet_dto_1.WalletTransactionSearchDTO]),
    __metadata("design:returntype", Promise)
], WalletTransactionController.prototype, "search", null);
exports.WalletTransactionController = WalletTransactionController = __decorate([
    (0, swagger_1.ApiTags)(wallet_service_1.WalletTransactionRoutePath.tag),
    (0, common_1.Controller)(wallet_service_1.WalletTransactionRoutePath.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [wallet_transaction_service_1.WalletTransactionService])
], WalletTransactionController);
//# sourceMappingURL=wallet-transaction.controller.js.map