import { WalletTransactionEntity } from './wallet.entity';
import { BaseService } from '../../services/base.service';
import { CreateWalletTransactionDTO, WalletTransactionSearchDTO } from './wallet.dto';
import { EntityManager, Repository } from 'typeorm';
import { WalletService } from './wallet.service';
import { ETransMethod } from './wallet.enum';
export declare class WalletTransactionService extends BaseService<WalletTransactionEntity, WalletTransactionSearchDTO> {
    protected repo: Repository<WalletTransactionEntity>;
    protected walletService: WalletService;
    protected _blackListedMethods: {
        [method in ETransMethod]?: boolean;
    };
    constructor(repo: Repository<WalletTransactionEntity>, walletService: WalletService);
    blacklistTransMethod(methods: ETransMethod[]): void;
    whiteListTransMethod(methods: ETransMethod[]): void;
    get blackListedMethods(): {
        System?: boolean;
        Manual?: boolean;
        "Bank Wire"?: boolean;
        Fincra?: boolean;
        Paystack?: boolean;
        Pay4it?: boolean;
    };
    create(walletID: string, data: CreateWalletTransactionDTO, config?: {
        entityManager?: EntityManager;
    }): Promise<WalletTransactionEntity>;
}
