"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletTransactionService = void 0;
const common_1 = require("@nestjs/common");
const wallet_entity_1 = require("./wallet.entity");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const search_enum_1 = require("../../enums/search.enum");
const wallet_service_1 = require("./wallet.service");
const utility_service_1 = require("../../services/utility.service");
const wallet_enum_1 = require("./wallet.enum");
let WalletTransactionService = class WalletTransactionService extends base_service_1.BaseService {
    constructor(repo, walletService) {
        super(repo, base_enum_1.ETableName.wallet);
        this.repo = repo;
        this.walletService = walletService;
        this._blackListedMethods = {};
        this.queryStruct = [
            { field: 'amount', upperRange: 'amountFrom', lowerRange: 'amountTo' },
            { field: 'amount' },
            { field: 'netBalanceBefore' },
            { field: 'grossBalanceBefore' },
            { field: 'type' },
            { field: 'currency' },
            { field: 'reason', condition: search_enum_1.ESearchCondition.contains },
            { field: 'transMethod' },
            { field: 'isVerified' },
            { field: 'isFailed' },
            { field: 'transactionReference' },
            { field: 'walletId' },
            {
                field: 'walletIds',
                actualField: 'walletId',
                condition: search_enum_1.ESearchCondition.in,
            },
            { field: 'refCat' },
            { field: 'userID' },
        ];
    }
    blacklistTransMethod(methods) {
        methods?.forEach((m) => (this._blackListedMethods[m] = true));
    }
    whiteListTransMethod(methods) {
        methods?.forEach((m) => (this._blackListedMethods[m] = false));
    }
    get blackListedMethods() {
        return { ...this._blackListedMethods };
    }
    async create(walletID, data, config) {
        await this.walletService.checkIfExistsById(walletID, {
            errorMessage: `Wallet could not be found`,
        });
        const wallet = await this.walletService.getComputedById(walletID);
        if (!wallet)
            utility_service_1.UtilityClass.throwError({
                message: `Wallet could not be found`,
                statusCode: 404,
            });
        if (this._blackListedMethods[data.transMethod])
            utility_service_1.UtilityClass.throwError({
                statusCode: 400,
                message: `Transaction method ${data.transMethod} is not allowed`,
            });
        if (data.type == wallet_enum_1.ETransactionType.debit &&
            data.amount > wallet.grossBalance)
            if (!wallet.allowOverdraft)
                utility_service_1.UtilityClass.throwError({
                    message: `You do not have a sufficient balance to fund this transaction`,
                });
            else if (data.amount >= wallet.overdraftLimit + wallet.grossBalance)
                utility_service_1.UtilityClass.throwError({
                    message: `You have gone past your overdraft limit and are therefore unable to fund this transaction`,
                });
        const entity = this.repo.create({
            ...data,
            netBalanceBefore: wallet.netBalance,
            grossBalanceBefore: wallet.grossBalance,
            wallet,
            userID: wallet.userID,
            orgID: wallet.orgID,
        });
        return (await config?.entityManager)
            ? config.entityManager.save(entity)
            : this._create(entity);
    }
};
exports.WalletTransactionService = WalletTransactionService;
exports.WalletTransactionService = WalletTransactionService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(wallet_entity_1.WalletTransactionEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        wallet_service_1.WalletService])
], WalletTransactionService);
//# sourceMappingURL=wallet-transaction.service.js.map