"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const wallet_dto_1 = require("./wallet.dto");
const base_dto_1 = require("../../dtos/base.dto");
const utility_service_1 = require("../../services/utility.service");
const wallet_service_1 = require("./wallet.service");
const wallet_enum_1 = require("./wallet.enum");
const search_dto_1 = require("../../dtos/search.dto");
const base_controller_1 = require("../../controllers/base.controller");
const wallet_transaction_service_1 = require("./wallet-transaction.service");
let WalletController = class WalletController extends base_controller_1.BaseController {
    constructor(service, transService) {
        super(service);
        this.service = service;
        this.transService = transService;
    }
    getTransactionTypes() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: Object.values(wallet_enum_1.ETransactionType),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    getCurrencies() {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: Object.values(wallet_enum_1.ECurrency),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    getTransactionMethods() {
        try {
            const blackListedMethods = this.transService.blackListedMethods;
            return utility_service_1.UtilityClass.handleSuccess({
                data: Object.values(wallet_enum_1.ETransMethod).filter((x) => !blackListedMethods[x] && x != wallet_enum_1.ETransMethod.system),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async create(data) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service._create(data),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async update(data, param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service._updateByID(param.id, data),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getByID(param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getComputedById(param.id),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    async getByUserID(param) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.getComputed({ userID: param.id }),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
    //   @Get('search')
    async search(query) {
        return super.search(query);
    }
    async searchComputedView(query) {
        try {
            return utility_service_1.UtilityClass.handleSuccess({
                data: await this.service.searchComputedView(query),
            });
        }
        catch (error) {
            return utility_service_1.UtilityClass.handleError(error);
        }
    }
};
exports.WalletController = WalletController;
__decorate([
    (0, common_1.Get)('transactionTypes'),
    (0, swagger_1.ApiOperation)({ summary: 'Get all transaction types' }),
    (0, swagger_1.ApiResponse)({ type: [String] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], WalletController.prototype, "getTransactionTypes", null);
__decorate([
    (0, common_1.Get)('currencies'),
    (0, swagger_1.ApiOperation)({ summary: 'Get all available currencies' }),
    (0, swagger_1.ApiResponse)({ type: [String] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], WalletController.prototype, "getCurrencies", null);
__decorate([
    (0, common_1.Get)('transactionMethods'),
    (0, swagger_1.ApiOperation)({ summary: 'Get available transaction methods' }),
    (0, swagger_1.ApiResponse)({ type: [String] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], WalletController.prototype, "getTransactionMethods", null);
__decorate([
    (0, common_1.Post)(''),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new wallet' }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wallet_dto_1.CreateWalletDTO]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update wallet by ID' }),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wallet_dto_1.UpdateWalletDto, base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "update", null);
__decorate([
    (0, common_1.Get)('getByID/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get wallet by ID with computed values' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "getByID", null);
__decorate([
    (0, common_1.Get)('getByUserID/:id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get wallets by user ID with computed values' }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [base_dto_1.IDDto]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "getByUserID", null);
__decorate([
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wallet_dto_1.WalletSearchDTO]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "search", null);
__decorate([
    (0, common_1.Get)('search'),
    (0, swagger_1.ApiOperation)({ summary: 'Search wallets with computed values' }),
    (0, swagger_1.ApiResponse)({ type: search_dto_1.SearchResponseDto }),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [wallet_dto_1.WalletSearchDTO]),
    __metadata("design:returntype", Promise)
], WalletController.prototype, "searchComputedView", null);
exports.WalletController = WalletController = __decorate([
    (0, swagger_1.ApiTags)(wallet_service_1.WalletRoutePath.tag),
    (0, common_1.Controller)(wallet_service_1.WalletRoutePath.path),
    (0, swagger_1.ApiBearerAuth)(),
    __metadata("design:paramtypes", [wallet_service_1.WalletService,
        wallet_transaction_service_1.WalletTransactionService])
], WalletController);
//# sourceMappingURL=wallet.controller.js.map