"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletEntities = exports.WalletBalanceView = exports.WalletTransactionEntity = exports.WalletExternalBank = exports.WalletEntity = void 0;
const typeorm_1 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const base_entity_1 = require("../../entities/base.entity");
const wallet_enum_1 = require("./wallet.enum");
let WalletEntity = class WalletEntity extends base_entity_1.BaseEntity {
};
exports.WalletEntity = WalletEntity;
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], WalletEntity.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], WalletEntity.prototype, "userID", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 150 }),
    __metadata("design:type", Object)
], WalletEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], WalletEntity.prototype, "allowOverdraft", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', default: 0 }),
    __metadata("design:type", Number)
], WalletEntity.prototype, "overdraftLimit", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => WalletTransactionEntity, (item) => item.wallet),
    __metadata("design:type", Array)
], WalletEntity.prototype, "transactions", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => WalletExternalBank, (item) => item.wallet),
    __metadata("design:type", Array)
], WalletEntity.prototype, "walletExternalBanks", void 0);
exports.WalletEntity = WalletEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.wallet)
], WalletEntity);
let WalletExternalBank = class WalletExternalBank extends base_entity_1.BaseEntity {
};
exports.WalletExternalBank = WalletExternalBank;
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 20, nullable: true }),
    __metadata("design:type", String)
], WalletExternalBank.prototype, "code", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 20, nullable: true }),
    __metadata("design:type", String)
], WalletExternalBank.prototype, "accountNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 200, nullable: true }),
    __metadata("design:type", String)
], WalletExternalBank.prototype, "bankName", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'nvarchar', length: 20, nullable: true }),
    __metadata("design:type", String)
], WalletExternalBank.prototype, "sortCode", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => WalletEntity, (item) => item.walletExternalBanks),
    __metadata("design:type", WalletEntity)
], WalletExternalBank.prototype, "wallet", void 0);
exports.WalletExternalBank = WalletExternalBank = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.walletExternalBank)
], WalletExternalBank);
let WalletTransactionEntity = class WalletTransactionEntity extends base_entity_1.BaseEntity {
};
exports.WalletTransactionEntity = WalletTransactionEntity;
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], WalletTransactionEntity.prototype, "amount", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double', default: 0 }),
    __metadata("design:type", Number)
], WalletTransactionEntity.prototype, "surcharge", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], WalletTransactionEntity.prototype, "netBalanceBefore", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'double' }),
    __metadata("design:type", Number)
], WalletTransactionEntity.prototype, "grossBalanceBefore", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: wallet_enum_1.ETransactionType }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "type", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: wallet_enum_1.ECurrency, default: wallet_enum_1.ECurrency.naira }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "currency", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "reason", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "refCat", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', nullable: false, enum: wallet_enum_1.ETransMethod }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "transMethod", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: true }),
    __metadata("design:type", Boolean)
], WalletTransactionEntity.prototype, "isVerified", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false, nullable: false }),
    __metadata("design:type", Boolean)
], WalletTransactionEntity.prototype, "isFailed", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false, nullable: true }),
    __metadata("design:type", Boolean)
], WalletTransactionEntity.prototype, "isOverdraft", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', unique: false }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "transactionReference", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], WalletTransactionEntity.prototype, "userID", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => WalletEntity, (item) => item.transactions),
    __metadata("design:type", WalletEntity)
], WalletTransactionEntity.prototype, "wallet", void 0);
exports.WalletTransactionEntity = WalletTransactionEntity = __decorate([
    (0, typeorm_1.Entity)(base_enum_1.ETableName.walletTransaction)
], WalletTransactionEntity);
let WalletBalanceView = class WalletBalanceView extends WalletEntity {
};
exports.WalletBalanceView = WalletBalanceView;
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], WalletBalanceView.prototype, "grossBalance", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], WalletBalanceView.prototype, "netBalance", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], WalletBalanceView.prototype, "grossTotalCredit", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], WalletBalanceView.prototype, "grossTotalDebit", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], WalletBalanceView.prototype, "netTotalCredit", void 0);
__decorate([
    (0, typeorm_1.ViewColumn)(),
    __metadata("design:type", Number)
], WalletBalanceView.prototype, "netTotalDebit", void 0);
exports.WalletBalanceView = WalletBalanceView = __decorate([
    (0, typeorm_1.ViewEntity)({
        expression: `
SELECT temp.*,
       temp.grossTotalCredit - temp.grossTotalDebit AS grossBalance,
       temp.netTotalCredit - temp.netTotalDebit AS netBalance
FROM   (SELECT wallet.*,
               Sum(CASE
                     WHEN wallet_transaction.type = 'CREDIT'
                          AND wallet_transaction.isFailed = 0 THEN
                     wallet_transaction.amount
                     ELSE 0
                   end) AS grossTotalCredit,
               Sum(CASE
                     WHEN wallet_transaction.type = 'DEBIT'
                          AND wallet_transaction.isFailed = 0 THEN
                     wallet_transaction.amount+ wallet_transaction.surcharge
                     ELSE 0
                   end) AS grossTotalDebit,
               Sum(CASE
                     WHEN wallet_transaction.type = 'CREDIT'
                          AND wallet_transaction.isFailed = 0
                          AND wallet_transaction.isVerified = 1 THEN
                     wallet_transaction.amount
                     ELSE 0
                   end) AS netTotalCredit,
               Sum(CASE
                     WHEN wallet_transaction.type = 'DEBIT'
                          AND wallet_transaction.isFailed = 0
                          AND wallet_transaction.isVerified = 1 THEN
                     wallet_transaction.amount+ wallet_transaction.surcharge
                     ELSE 0
                   end) AS netTotalDebit
        FROM   wallet
               LEFT JOIN wallet_transaction
                      ON wallet.id = wallet_transaction.walletId
        GROUP  BY wallet.id) AS temp; 
   `,
        name: base_enum_1.ETableName.walletBalanceView,
    })
], WalletBalanceView);
exports.WalletEntities = [
    WalletEntity,
    WalletTransactionEntity,
    WalletBalanceView,
    // WalletBalanceView,
    WalletExternalBank,
];
//# sourceMappingURL=wallet.entity.js.map