import { WalletEntity, WalletBalanceView } from './wallet.entity';
import { BaseService } from '../../services/base.service';
import { CreateWalletDTO, WalletSearchDTO } from './wallet.dto';
import { FindOptionsSelect, FindOptionsWhere, Repository } from 'typeorm';
import { RoutePath } from '../../classes/route-path.class';
import { ICreateConfig } from '../../interfaces/index.interface';
export declare const WalletRoutePath: RoutePath;
export declare const WalletTransactionRoutePath: RoutePath;
export declare class WalletService extends BaseService<WalletEntity, WalletSearchDTO> {
    protected repo: Repository<WalletEntity>;
    protected repoWalletBalanceView: Repository<WalletBalanceView>;
    constructor(repo: Repository<WalletEntity>, repoWalletBalanceView: Repository<WalletBalanceView>);
    readonly computedLiteSelect: FindOptionsSelect<WalletBalanceView>;
    getComputedById(walletID: string, lite?: boolean): Promise<WalletBalanceView>;
    getComputed(query: FindOptionsWhere<WalletBalanceView>, lite?: boolean): Promise<WalletBalanceView>;
    _createChecks(data: CreateWalletDTO): Promise<void>;
    _create(data: CreateWalletDTO, config?: ICreateConfig): Promise<WalletEntity>;
    searchComputedView({ grossBalance, grossBalanceFrom, grossBalanceTo, grossTotalCredit, grossTotalCreditFrom, grossTotalCreditTo, grossTotalDebit, grossTotalDebitFrom, grossTotalDebitTo, netBalance, netBalanceFrom, netBalanceTo, netTotalCredit, netTotalCreditFrom, netTotalCreditTo, netTotalDebit, netTotalDebitFrom, netTotalDebitTo, overdraftLimit, overdraftLimitFrom, overdraftLimitTo, ...query }: WalletSearchDTO): Promise<import("../..").ISearchResponse<WalletBalanceView>>;
}
