"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WalletService = exports.WalletTransactionRoutePath = exports.WalletRoutePath = void 0;
const common_1 = require("@nestjs/common");
const wallet_entity_1 = require("./wallet.entity");
const base_service_1 = require("../../services/base.service");
const base_enum_1 = require("../../enums/base.enum");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const utility_service_1 = require("../../services/utility.service");
const route_path_class_1 = require("../../classes/route-path.class");
exports.WalletRoutePath = new route_path_class_1.RoutePath('wallet');
exports.WalletTransactionRoutePath = new route_path_class_1.RoutePath('transaction', exports.WalletRoutePath);
let WalletService = class WalletService extends base_service_1.BaseService {
    constructor(repo, repoWalletBalanceView) {
        super(repo, base_enum_1.ETableName.wallet);
        this.repo = repo;
        this.repoWalletBalanceView = repoWalletBalanceView;
        this.computedLiteSelect = {
            grossBalance: true,
            netBalance: true,
            grossTotalCredit: true,
            grossTotalDebit: true,
            netTotalCredit: true,
            netTotalDebit: true,
        };
    }
    getComputedById(walletID, lite) {
        return this.repoWalletBalanceView.findOne({
            where: { id: walletID },
            select: lite ? this.computedLiteSelect : undefined,
        });
    }
    getComputed(query, lite) {
        return this.repoWalletBalanceView.findOne({
            where: query,
            select: lite ? this.computedLiteSelect : undefined,
        });
    }
    async _createChecks(data) {
        await this.checkIfUniqueBy({
            userID: data.userID,
            orgID: data.orgID,
            type: data.type,
        });
    }
    _create(data, config) {
        return super._create(data, config);
    }
    searchComputedView({ grossBalance, grossBalanceFrom, grossBalanceTo, grossTotalCredit, grossTotalCreditFrom, grossTotalCreditTo, grossTotalDebit, grossTotalDebitFrom, grossTotalDebitTo, netBalance, netBalanceFrom, netBalanceTo, netTotalCredit, netTotalCreditFrom, netTotalCreditTo, netTotalDebit, netTotalDebitFrom, netTotalDebitTo, overdraftLimit, overdraftLimitFrom, overdraftLimitTo, ...query }) {
        return utility_service_1.UtilityClass.search(this.repoWalletBalanceView, query, {
            baseOrder: { createdAt: 'desc' },
            baseWhere: {
                grossBalance: utility_service_1.UtilityClass.computeRangeQuery(grossBalance, grossBalanceFrom, grossBalanceTo),
                netBalance: utility_service_1.UtilityClass.computeRangeQuery(netBalance, netBalanceFrom, netBalanceTo),
                grossTotalCredit: utility_service_1.UtilityClass.computeRangeQuery(grossTotalCredit, grossTotalCreditFrom, grossTotalCreditTo),
                grossTotalDebit: utility_service_1.UtilityClass.computeRangeQuery(grossTotalDebit, grossTotalDebitFrom, grossTotalDebitTo),
                netTotalCredit: utility_service_1.UtilityClass.computeRangeQuery(netTotalCredit, netTotalCreditFrom, netTotalCreditTo),
                netTotalDebit: utility_service_1.UtilityClass.computeRangeQuery(netTotalDebit, netTotalDebitFrom, netTotalDebitTo),
                overdraftLimit: utility_service_1.UtilityClass.computeRangeQuery(overdraftLimit, overdraftLimitFrom, overdraftLimitTo),
            },
        });
    }
};
exports.WalletService = WalletService;
exports.WalletService = WalletService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(wallet_entity_1.WalletEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(wallet_entity_1.WalletBalanceView)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], WalletService);
//# sourceMappingURL=wallet.service.js.map