import { WPSiteEntity } from './wordpress.entity';
import { BaseCRUDController } from '../../controllers/base.controller';
import { CreateWPSiteDTO, SearchWPSiteDTO, UpdateWPSiteDTO, WPCheckDomainDTO, WPItemQuery, WPListQuery } from './wordpress.dto';
import { WordpressService } from './wordpress.service';
import { IAuthParam } from '../authentication/authentication.interface';
import { IDDto } from '../../dtos/base.dto';
import { WPPost, WPPostListQuery, WPPostSearchResponseDto } from './wordpress-post.dto';
import { WPPage, WPPageSearchResponseDto } from './wordpress-page.dto';
import { WPCategory, WPCategorySearchResponseDto } from './wordpress-category.dto';
import { WPTag, WPTagSearchResponseDto } from './wordpress-tag.dto';
import { RoutePath } from '../../classes/route-path.class';
export declare const WordpressRoutePath: RoutePath;
export declare class WordpressController extends BaseCRUDController<WPSiteEntity, SearchWPSiteDTO> {
    protected readonly service: WordpressService;
    constructor(service: WordpressService);
    create(body: CreateWPSiteDTO, auth: IAuthParam): string | Promise<WPSiteEntity>;
    updateByID(param: IDDto, body: UpdateWPSiteDTO, auth: IAuthParam): string | Promise<WPSiteEntity>;
    search(query: SearchWPSiteDTO): Promise<string | import("../..").ISearchResponse<WPSiteEntity>>;
    checkDomain(query: WPCheckDomainDTO): Promise<string | {
        status: boolean;
        message: any;
    }>;
    getCategories(query: WPListQuery): Promise<string | WPCategorySearchResponseDto>;
    getCategory(query: WPItemQuery): Promise<string | WPCategory>;
    getPosts(query: WPPostListQuery): Promise<string | WPPostSearchResponseDto>;
    getPost(query: WPItemQuery): Promise<string | WPPost>;
    getPages(query: WPListQuery): Promise<string | WPPageSearchResponseDto>;
    getPage(query: WPItemQuery): Promise<string | WPPage>;
    getTags(query: WPListQuery): Promise<string | WPTagSearchResponseDto>;
    getTag(query: WPItemQuery): Promise<string | WPTag>;
    getWPAPI(): Promise<string | {
        active: boolean;
    }>;
}
