"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WordpressService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const base_enum_1 = require("../../enums/base.enum");
const search_enum_1 = require("../../enums/search.enum");
const base_service_1 = require("../../services/base.service");
const wordpress_entity_1 = require("./wordpress.entity");
const WPAPI = require("wpapi");
const utility_service_1 = require("../../services/utility.service");
let WordpressService = class WordpressService extends base_service_1.BaseService {
    constructor(repo) {
        super(repo, base_enum_1.ETableName.wpSite);
        this.repo = repo;
        this.tagSlugToIDMap = {};
        this.categorySlugToIDMap = {};
        this.errorParser = (e) => utility_service_1.UtilityClass.throwError({ message: e.message, statusCode: 400 });
        this.queryStruct = [
            { field: 'domain', condition: search_enum_1.ESearchCondition.contains },
            { field: 'name', condition: search_enum_1.ESearchCondition.contains },
            { field: 'slug' },
        ];
    }
    async getWPAPI() {
        if (!this.currentConfig?.currentSite) {
            const currentSite = await this.repo.findOne({ where: { active: true } });
            if (!currentSite)
                utility_service_1.UtilityClass.throwError({
                    statusCode: 404,
                    message: `No Wordpress site has been set`,
                });
            this.currentConfig = {
                currentWPAPI: new WPAPI({
                    endpoint: currentSite.domain + '/wp-json',
                }),
                currentSite,
            };
        }
        return this.currentConfig;
    }
    resetWPAPI() {
        this.currentConfig = undefined;
        this.tagSlugToIDMap = {};
        this.categorySlugToIDMap = {};
        this.getWPAPI();
    }
    async checkDomain(query) {
        return new WPAPI({
            endpoint: query.domain + '/wp-json',
        })
            .posts()
            .perPage(1)
            .get()
            .then((r) => ({ status: !!r, message: 'Verified' }))
            .catch((e) => {
            return { status: false, message: e.message };
        });
    }
    async _createChecks(data) {
        await this.checkIfUniqueBy({ slug: data.slug }, { errorMessage: 'Slug already exists' });
    }
    async toggleActive(id, body) {
        const res = await super.toggleActive(id, body);
        if (body.active)
            this.repo.update({ id: (0, typeorm_2.Not)(id) }, { active: false });
        this.resetWPAPI();
        return res;
    }
    async _postCreateFunction(requestData, savedData) {
        this.resetWPAPI();
        this.toggleActive(savedData.id, { active: true });
    }
    async _preCreateFunction(data) {
        const res = await this.checkDomain(data);
        if (!res.status)
            utility_service_1.UtilityClass.throwError({
                message: 'Domain is invalid',
                statusCode: 400,
            });
    }
    async _postUpdateFunction(id, data) {
        data;
        this.resetWPAPI();
    }
    async _updateChecks(id, data) {
        await this.checkIfUniqueBy({ slug: data.slug, id: (0, typeorm_2.Not)(id) }, { errorMessage: 'Slug already exists' });
    }
    async itemResponseWrapper(request, query, formatter) {
        if (query.id)
            request.id(query.id);
        else if (query.slug)
            request.slug(query.slug);
        else {
            utility_service_1.UtilityClass.throwError({
                message: `At least one of ${Object.keys(query)} is required`,
            });
        }
        let item = await request.then((r) => r).catch(this.errorParser);
        if (Array.isArray(item))
            item = item[0];
        return formatter ? formatter(item) : item;
    }
    async searchResponseWrapper(request, query, formatter) {
        const pageNumber = +query.pageNumber || 1;
        const pageSize = +query.pageSize || 1;
        const sortField = query.sortField;
        const sortDirection = sortField
            ? query.sortDirection?.toLowerCase() || 'asc'
            : undefined;
        const queryBuilder = request.page(pageNumber).perPage(pageSize);
        if (sortField)
            queryBuilder.orderby(sortField).order(sortDirection);
        if (query.createdFrom)
            queryBuilder.after(query.createdFrom);
        if (query.createdTo)
            queryBuilder.before(query.createdTo);
        // if (query.status) queryBuilder.status(query.status);
        if (query.categoryID || query.categorySlug) {
            const slugs = query.categorySlug
                ? Array.isArray(query.categorySlug)
                    ? query.categorySlug
                    : [query.categorySlug]
                : [];
            const ids = query.categoryID
                ? Array.isArray(query.categoryID)
                    ? query.categoryID
                    : [query.categoryID]
                : [];
            if (slugs.length)
                ids.push(...(await Promise.all(slugs.map((slug) => this.categorySlugToIDMap[slug] ||
                    this.getCategory({ slug }).then((r) => {
                        this.categorySlugToIDMap[slug] = r.id;
                        return r.id;
                    })))));
            queryBuilder.categories(ids);
        }
        if (query.tagID || query.tagSlug) {
            const slugs = query.tagSlug
                ? Array.isArray(query.tagSlug)
                    ? query.tagSlug
                    : [query.tagSlug]
                : [];
            const ids = query.tagID
                ? Array.isArray(query.tagID)
                    ? query.tagID
                    : [query.tagID]
                : [];
            if (slugs.length)
                ids.push(...(await Promise.all(slugs.map((slug) => this.tagSlugToIDMap[slug] ||
                    this.getTag({ slug }).then((r) => {
                        this.tagSlugToIDMap[slug] = r.id;
                        return r.id;
                    })))));
            queryBuilder.tags(ids);
        }
        const data = await queryBuilder
            .then((r) => r)
            .catch(this.errorParser);
        return {
            data: formatter ? data?.map(formatter) : data,
            total: 0,
            pageNumber,
            pageSize,
            sortField,
            sortDirection,
            dataLength: data?.length || 0,
        };
    }
    async getPosts(query) {
        return this.searchResponseWrapper((await this.getWPAPI()).currentWPAPI.posts(), query);
    }
    async getPost(query) {
        return this.itemResponseWrapper((await this.getWPAPI()).currentWPAPI.posts(), query);
    }
    async getPages(query) {
        return this.searchResponseWrapper((await this.getWPAPI()).currentWPAPI.pages(), query);
    }
    async getPage(query) {
        return this.itemResponseWrapper((await this.getWPAPI()).currentWPAPI.pages(), query);
    }
    async getTags(query) {
        return this.searchResponseWrapper((await this.getWPAPI()).currentWPAPI.tags(), query);
    }
    async getTag(query) {
        return this.itemResponseWrapper((await this.getWPAPI()).currentWPAPI.tags(), query);
    }
    async getCategories(query) {
        return this.searchResponseWrapper((await this.getWPAPI()).currentWPAPI.categories(), query);
    }
    async getCategory(query) {
        return this.itemResponseWrapper((await this.getWPAPI()).currentWPAPI.categories(), query);
    }
};
exports.WordpressService = WordpressService;
WordpressService.path = 'wp';
exports.WordpressService = WordpressService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(wordpress_entity_1.WPSiteEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], WordpressService);
//# sourceMappingURL=wordpress.service.js.map