"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.APIService = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const environment_service_1 = require("./environment.service");
const utility_service_1 = require("./utility.service");
// import { logger } from './logger.service';
let APIService = class APIService {
    constructor(httpService) {
        this.httpService = httpService;
        this.verbose = environment_service_1.evt.ENVIRONMENT != 'production';
        this.handleResponse = (res) => res.data;
        this.handleError = (e) => {
            // logger.error(e);
            return utility_service_1.UtilityClass.throwError({
                message: e.response.data,
                statusCode: e.response.status,
            });
        };
    }
    get(route, queryParams, extras) {
        try {
            return (0, rxjs_1.lastValueFrom)(this.httpService.get(this.formatURL(route, queryParams), extras?.axiosConfig))
                .then(this.handleResponse)
                .catch(this.handleError);
        }
        catch (error) {
            utility_service_1.UtilityClass.throwError({ message: error });
        }
    }
    post(route, body, extras) {
        try {
            return (0, rxjs_1.lastValueFrom)(this.httpService.post(this.formatURL(route), body, extras?.axiosConfig))
                .then(this.handleResponse)
                .catch(this.handleError);
        }
        catch (error) {
            utility_service_1.UtilityClass.throwError({ message: error });
        }
    }
    log(...items) {
        if (this.verbose)
            console.log(...items);
    }
    formatURL(route, parameters) {
        const res = !parameters
            ? route
            : route +
                (route.includes('?') ? '&' : `?`) +
                Object.keys(parameters)
                    .filter((key) => parameters[key]?.toString()?.trim() != null)
                    .map((key) => `${key}=${parameters[key]?.toString()?.trim()}`)
                    .join('&');
        this.log(route, parameters, res);
        return res;
    }
};
exports.APIService = APIService;
exports.APIService = APIService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [axios_1.HttpService])
], APIService);
//# sourceMappingURL=api.service.js.map