import { DataSource, EntityTarget, FindOptionsWhere, QueryRunner, Repository } from 'typeorm';
import { ICheckByParams } from '../interfaces/base.interface';
import { ToggleActiveDTO } from '../dtos/base.dto';
import { SharedRepositoryService } from './shared-repository.service';
import { SearchQueryDto } from '../dtos/search.dto';
export declare class CustomRepositoryService<TEntity, TSearchDto extends SearchQueryDto = SearchQueryDto> extends Repository<TEntity> {
    target: EntityTarget<TEntity>;
    dataSource: DataSource;
    queryRunner?: QueryRunner;
    protected sharedRepositoryService: SharedRepositoryService<TEntity, TSearchDto>;
    constructor(target: EntityTarget<TEntity>, dataSource: DataSource, queryRunner?: QueryRunner);
    _checkIfExistsById(id: string, config?: Pick<ICheckByParams<TEntity>['config'], 'throwError' | 'errorMessage'>): Promise<boolean>;
    _checkIfExistsBy(where: ICheckByParams<TEntity>['where'], config?: Omit<ICheckByParams<TEntity>['config'], 'shouldExist'>): Promise<boolean>;
    _checkIfUniqueById(id: string, config?: Pick<ICheckByParams<TEntity>['config'], 'throwError' | 'errorMessage'>): Promise<boolean>;
    _checkIfUniqueBy(where: ICheckByParams<TEntity>['where'], config?: Omit<ICheckByParams<TEntity>['config'], 'shouldExist'>): Promise<boolean>;
    _checkExistenceBy(where: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[], config: ICheckByParams<TEntity>['config']): Promise<boolean>;
    _getAllIDs(where?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[]): Promise<string[]>;
    _toggleActive(id: string, body: ToggleActiveDTO): Promise<boolean>;
}
