"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logger$ = exports.initLogger = exports.logger = exports.stream = void 0;
const fs = require("fs");
const path = require("path");
const rxjs_1 = require("rxjs");
const winston = require("winston");
const winstonDaily = require("winston-daily-rotate-file");
let _logger;
// debugger;
// logs dir
const initLogger = (logDir = path.join(__dirname, '../logs')) => {
    if (!fs.existsSync(logDir)) {
        fs.mkdirSync(logDir);
    }
    // Define log format
    const logFormat = winston.format.printf(({ timestamp, level, message }) => {
        logger$.next({ message, isError: level == 'error' });
        return `${timestamp} ${level}: ${message}`;
    });
    /*
     * Log Level
     * error: 0, warn: 1, info: 2, http: 3, verbose: 4, debug: 5, silly: 6
     */
    _logger = winston.createLogger({
        format: winston.format.combine(winston.format.timestamp({
            format: 'YYYY-MM-DD HH:mm:ss',
        }), logFormat),
        transports: [
            // debug log setting
            new winstonDaily({
                level: 'debug',
                datePattern: 'YYYY-MM-DD',
                dirname: logDir + '/debug', // log file /logs/debug/*.log in save
                filename: `%DATE%.log`,
                maxFiles: 30, // 30 Days saved
                json: false,
                zippedArchive: true,
            }),
            // error log setting
            new winstonDaily({
                level: 'error',
                datePattern: 'YYYY-MM-DD',
                dirname: logDir + '/error', // log file /logs/error/*.log in save
                filename: `%DATE%.log`,
                maxFiles: 30, // 30 Days saved
                handleExceptions: true,
                json: false,
                zippedArchive: true,
            }),
        ],
    });
    _logger.add(new winston.transports.Console({
        format: winston.format.combine(winston.format.splat(), winston.format.colorize()),
    }));
};
exports.initLogger = initLogger;
const stream = {
    write: (message) => {
        _logger.info(message.substring(0, message.lastIndexOf('\n')));
    },
};
exports.stream = stream;
const logger = {
    info: (val, ...meta) => _logger.info(JSON.stringify(val), meta),
    error: (val, ...meta) => _logger.error(JSON.stringify(val), meta),
};
exports.logger = logger;
const logger$ = new rxjs_1.Subject();
exports.logger$ = logger$;
//# sourceMappingURL=logger.service.js.map