import Mail from 'nodemailer/lib/mailer';
import { SDKConfig } from '../configs/index.config';
import SMTPTransport from 'nodemailer/lib/smtp-transport';
import { ISDKEnvironment } from './environment.service';
export declare class MailService {
    /**@example `@mail.com` */
    static baseEmailSuffix: string;
    static loadConfig(config?: {
        smtp?: typeof SDKConfig.email;
        adminNotificationMails?: string[];
    }): void;
    static loadConfigFromEnvironment(environment: ISDKEnvironment): void;
    static sendMail(config: Mail.Options & {
        _senderName?: string;
    }): Promise<void | SMTPTransport.SentMessageInfo>;
    static sendCrashNotification(error: any): Promise<void | SMTPTransport.SentMessageInfo>;
    static sendToAdmin(data: {
        subject: string;
        text?: string;
        html?: string;
    }): Promise<void | SMTPTransport.SentMessageInfo>;
}
