"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedRepositoryService = void 0;
const utility_service_1 = require("./utility.service");
const search_service_1 = require("./search.service");
class SharedRepositoryService {
    async checkIfExistsById(repo, id, config) {
        return this.checkExistenceBy(repo, { id }, {
            shouldExist: true,
            ...(config || {}),
        });
    }
    async checkIfExistsBy(repo, where, config) {
        return this.checkExistenceBy(repo, where, {
            shouldExist: true,
            ...(config || {}),
        });
    }
    async checkIfUniqueById(repo, id, config) {
        return this.checkExistenceBy(repo, { id }, {
            shouldExist: false,
            ...(config || {}),
        });
    }
    async checkIfUniqueBy(repo, where, config) {
        return this.checkExistenceBy(repo, where, {
            shouldExist: false,
            ...(config || {}),
        });
    }
    async checkExistenceBy(repo, where, config) {
        if (!Object.values(where || {}).some((x) => x != null))
            utility_service_1.UtilityClass.throwError({ message: `Check query was not provided` });
        const exists = await repo.exist({
            where: where,
        });
        if (exists != config.shouldExist &&
            ((config.errorMessage && config.throwError !== false) ||
                config.throwError === true))
            utility_service_1.UtilityClass.throwError({
                statusCode: config.shouldExist ? 404 : 409,
                message: config.errorMessage ||
                    (config.shouldExist ? `It does not exist` : `It already exists`),
            });
        return exists;
    }
    async getAllIDs(repo, where) {
        return (await repo.find({
            select: { id: true },
            where: where,
        })).map((x) => x.id);
    }
    async toggleActive(repo, id, body) {
        if (!(await this.checkIfExistsById(repo, id)))
            utility_service_1.UtilityClass.throwError({
                message: `ID does not exist`,
                statusCode: 404,
            });
        await repo.update({ id: id }, body);
        return true;
    }
    async search(repo, tableName, queryStruct, query, auth) {
        auth;
        const res = await search_service_1.SearchService.search({
            repository: repo,
            tableName: tableName,
        }, query, queryStruct);
        res.data?.forEach((x) => {
            if (x.creator)
                x.creator = {
                    firstname: x.creator.firstname,
                    lastname: x.creator.lastname,
                    id: x.creator.id,
                };
        });
        return res;
    }
}
exports.SharedRepositoryService = SharedRepositoryService;
//# sourceMappingURL=shared-repository.service.js.map