import { SMSSPBase } from './sms-sp.class';
import { ISMSMessage } from '../../interfaces/sms.interface';
import { ESMSProvider } from '../../enums/sms.enum';
export declare class SMSService {
    protected static providers: {
        [key in ESMSProvider]?: SMSSPBase;
    };
    protected static _defaultProviderKey: ESMSProvider;
    static addProvider(provider: SMSSPBase): void;
    static removeProvider(key: ESMSProvider, replacementKey?: ESMSProvider): void;
    protected static getProvider(key?: ESMSProvider): SMSSPBase;
    static setDefaultProvider(key: ESMSProvider): void;
    static get defaultProviderKey(): ESMSProvider;
    static loadProviders(providerKeys: ESMSProvider[]): void;
    static send(config: ISMSMessage): Promise<unknown>;
    static sendCrashNotification(error: any): Promise<unknown[]>;
    static sendToAdmin(data: Omit<ISMSMessage, 'recipient'>): Promise<unknown[]>;
}
