"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SMSService = void 0;
const index_config_1 = require("../../configs/index.config");
const sms_enum_1 = require("../../enums/sms.enum");
const bulk_sms_nigeria_service_1 = require("./bulk-sms-nigeria.service");
class SMSService {
    static addProvider(provider) {
        this.providers[provider.providerKey]?.destroy();
        this.providers[provider.providerKey] = provider;
    }
    static removeProvider(key, replacementKey) {
        if (this._defaultProviderKey == key)
            if (!replacementKey)
                throw `Set the provider to replace as the default provider`;
            else
                this._defaultProviderKey = replacementKey;
        this.providers[key]?.destroy();
        delete this.providers[key];
    }
    static getProvider(key = this._defaultProviderKey) {
        return this.providers[key];
    }
    static setDefaultProvider(key) {
        this._defaultProviderKey = key;
    }
    static get defaultProviderKey() {
        return this._defaultProviderKey;
    }
    static loadProviders(providerKeys) {
        for (const key of providerKeys) {
            if (key == sms_enum_1.ESMSProvider.bulkSMSNG)
                this.addProvider(bulk_sms_nigeria_service_1.BulkSMSNGService);
        }
        if (!this.defaultProviderKey)
            this.setDefaultProvider(providerKeys?.[0]);
    }
    static send(config) {
        return new Promise(async (res, rej) => {
            const provider = this.getProvider();
            if (!provider)
                rej(`There is no provider to handle this request`);
            else {
                try {
                    const r = await provider.send(config);
                    res(r);
                }
                catch (error) {
                    rej(error);
                }
            }
        });
    }
    static sendCrashNotification(error) {
        return this.sendToAdmin({
            message: `Server crashed\nTime: ${new Date()}\n\n\nError\n\n${error?.toString()}`,
        });
    }
    static async sendToAdmin(data) {
        return await Promise.all(index_config_1.SDKConfig.adminNotificationPhonenumbers.map((recipient) => this.send({
            recipient,
            message: data.message,
        })));
    }
}
exports.SMSService = SMSService;
SMSService.providers = {};
//# sourceMappingURL=sms.service.js.map