import { JwtService, JwtSignOptions } from '@nestjs/jwt';
import { Repository } from 'typeorm';
import { TokenSessionEntity } from '../entities/token-session.entity';
import { BaseService } from './base.service';
import { CreateTokenDto } from '../dtos/token.dto';
export declare class TokenService {
    protected jwtService: JwtService;
    constructor(jwtService: JwtService);
    generateToken<T = any>(payload: T, options?: JwtSignOptions): Promise<{
        token: string;
    }>;
    decryptToken<TData extends object>(token: string, options?: {
        ignoreExpiration?: boolean;
    }): Promise<TData>;
}
export declare class TokenSessionService extends BaseService<TokenSessionEntity> {
    protected readonly repo: Repository<TokenSessionEntity>;
    constructor(repo: Repository<TokenSessionEntity>);
    _create(data: CreateTokenDto): Promise<TokenSessionEntity>;
    drop(param: Partial<TokenSessionEntity>): Promise<TokenSessionEntity | import("typeorm").UpdateResult | import("typeorm").UpdateResult[]>;
}
export declare class TokenServiceModule {
}
