import { HttpStatus, INestApplication } from '@nestjs/common';
import { FileEntity } from '../entities/file.entity';
import { IObjectLiteral, UtilityClass as UC } from '@serene-dev/ts-helpers';
import { IAuthParam } from '../modules/authentication/authentication.interface';
import { ColumnOptions, FindOperator, FindOptionsOrder, FindOptionsRelations, FindOptionsSelect, FindOptionsWhere, Repository, SortDirection } from 'typeorm';
import { SearchQueryDto } from '../dtos/search.dto';
import { ISearchResponse } from '../interfaces/search.interface';
import { BaseEntity } from '../entities/base.entity';
import { BaseDto, ValueLabelDto } from '../dtos/base.dto';
import { SwaggerUiOptions } from '@nestjs/swagger/dist/interfaces/swagger-ui-options.interface';
import { IClassValidatorError } from '../interfaces/class-validator-error.interface';
import { ViewColumnOptions } from 'typeorm/decorator/options/ViewColumnOptions';
export declare class UtilityClass {
    static sdkUtility: UC;
    static handleSuccess: <TData>(res: {
        data?: TData;
        message?: string;
    }) => string | TData;
    static monthBackOrdering: {
        [key: string]: {
            id: number;
            short: string;
            isoStr: string;
            long: string;
        }[];
        [key: number]: {
            id: number;
            short: string;
            isoStr: string;
            long: string;
        }[];
    };
    static swaggerUILink: string;
    static backOrderingArray<T>(arr: T[], key: keyof T): {
        [key: string | number]: T[];
    };
    static get generateUserName(): string;
    static get generateStarwars(): string;
    static castObject: <TEntity>(newObejct: TEntity) => TEntity;
    static getOSSystem(): {
        [x: string]: any;
    };
    static removeNull<T>(obj: T): T;
    static computeArrayFieldQuery<T>(query?: T | T[]): T | FindOperator<any>;
    /**
     * This handles user defined errors and system generated errors
     * @param res
     */
    static handleError: <TData>(res: {
        error?: TData;
        message?: string;
        statusCode?: HttpStatus;
    }) => never;
    static otpGenerator(length?: number): string;
    static pathToLink(file: FileEntity): string;
    static get getHost(): string;
    static enableSwagger(app: INestApplication<any>, config: {
        modules?: Function[];
        appName: string;
        path: string;
        docExpansion?: 'none' | 'list';
        versionNo?: string;
        swaggerOptions?: SwaggerUiOptions;
    }): void;
    static likeFormatter(value: string): FindOperator<string>;
    static dbTimezoneOffset: number;
    static columnTimestamp: ColumnOptions;
    static setDbTimezoneOffset(hours: number): void;
    static readonly transformerNumber: ViewColumnOptions;
    static readonly transformerBoolean: ViewColumnOptions;
    static patchUpdater<T extends IObjectLiteral>(body: T, auth: Pick<IAuthParam, 'id'>): T;
    static patchCreator<T extends IObjectLiteral>(body: T, auth: Pick<IAuthParam, 'id'>): T;
    static patchOwner<T extends BaseDto>(body: T, auth: Pick<IAuthParam, 'id'>, authField: 'updater' | 'creator'): T;
    /**
     * This is a user defined error
     * @param payload
     */
    static throwError: <TData>(payload: {
        error?: TData;
        message?: string;
        statusCode?: number;
    }) => never;
    static handleClassValidatorErrors: (e: IClassValidatorError) => never;
    static get generateUUID(): string;
    static computeRangeQuery<TValue>(exactValue: TValue, lowerRange: TValue, upperRange: TValue): FindOperator<TValue> | TValue;
    static returnEnums(enums: {
        [name: string]: {
            [name: string]: string;
        };
    }): string | {
        [name: string]: ValueLabelDto<any>[];
    };
    static returnEnum(enumm: {
        [name: string]: string;
    }): string | ValueLabelDto<any>[];
    static searchGeneric<TSearchQuery, TEntity>(repository: Repository<TEntity>, searchQuery: TSearchQuery, config: {
        pagination: {
            pageSize: number;
            pageNumber: number;
            sortDirection: SortDirection;
            sortField: keyof TEntity;
        };
        baseWhere?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[];
        baseOrder?: FindOptionsOrder<TEntity>;
        baseRelations?: FindOptionsRelations<TEntity>;
        baseSelect?: FindOptionsSelect<TEntity>;
    }): Promise<ISearchResponse<TEntity>>;
    static search<TEntity extends BaseEntity, TSearchQuery extends SearchQueryDto<TEntity>>(repository: Repository<TEntity>, query: TSearchQuery, config?: {
        baseWhere?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[];
        baseOrder?: FindOptionsOrder<TEntity>;
        baseRelations?: FindOptionsRelations<TEntity>;
        baseSelect?: FindOptionsSelect<TEntity>;
    }): Promise<ISearchResponse<TEntity>>;
    static searchView<TEntity, TSearchQuery extends SearchQueryDto<TEntity>>(repository: Repository<TEntity>, { createdAt, createdFrom, createdTo, updatedAt, updatedFrom, updatedTo, ...query }: TSearchQuery, config?: {
        baseWhere?: FindOptionsWhere<TEntity> | FindOptionsWhere<TEntity>[];
        baseOrder?: FindOptionsOrder<TEntity>;
        baseRelations?: FindOptionsRelations<TEntity>;
        baseSelect?: FindOptionsSelect<TEntity>;
    }): Promise<ISearchResponse<TEntity>>;
    static strConcatenator(field1?: string, field2?: string, joiner?: string): string;
    static emailTemplater: (header: string, body: string) => Promise<string>;
}
