"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptorClass = void 0;
const crypto_js_1 = require("crypto-js");
class EncryptorClass {
    /**
     * Encryption Decryption service
     */
    constructor() {
        this.RESPONSE_AESKEY = 'prao7lqjpgymv60eltc6tbdiahe69wf4';
        this.secret = this.RESPONSE_AESKEY;
        this.plusDelimiter = '~---~~';
        this.encryptText = (data, key = this.secret) => {
            let encText = crypto_js_1.AES.encrypt(JSON.stringify(data), key).toString();
            // enc = enc.split('/').join(this.delimiter);
            encText = encText.split('+').join(this.plusDelimiter);
            return encText;
        };
        this.decryptText = (data, key = this.secret) => {
            const encText = data.split(this.plusDelimiter).join('+');
            return JSON.parse(crypto_js_1.AES.decrypt(encText, key).toString(crypto_js_1.enc.Utf8));
        };
        /**
         * Encrypts an item
         * @param data Item
         * @returns Encrypted Object
         */
        this.encryptItem = (data) => {
            try {
                if (this.RESPONSE_AESKEY) {
                    return crypto_js_1.AES.encrypt(JSON.stringify(data), this.RESPONSE_AESKEY).toString();
                }
                throw new Error('AES and IV keys must be set');
            }
            catch (error) {
                throw error;
            }
        };
        /**
         * Decrypts an encrypted item
         * @param data Encrypted string
         * @returns Decrypted Object
         */
        this.decryptItem = (data) => {
            try {
                if (this.RESPONSE_AESKEY) {
                    // debugger
                    if (typeof data != 'string')
                        return data;
                    const decryptedData = crypto_js_1.AES.decrypt(data, this.RESPONSE_AESKEY || '');
                    const d = JSON.parse(decryptedData.toString(crypto_js_1.enc.Utf8));
                    console.log(d);
                    return d;
                }
                throw new Error('AES and IV keys must be set');
            }
            catch (error) {
                throw error;
            }
        };
    }
}
exports.EncryptorClass = EncryptorClass;
//# sourceMappingURL=encryptor.class.js.map