import { EncryptorClass } from './encryptor.class';
export declare class StorageClass {
    protected eS: EncryptorClass;
    /**
     * Specify whether it is a production environment
     */
    readonly isProduction: boolean;
    /**
     * name of local storage location
     */
    readonly storageKey: 'localStorage' | 'sessionStorage';
    protected customConfig: IStorageConfig;
    constructor(eS: EncryptorClass, 
    /**
     * Specify whether it is a production environment
     */
    isProduction: boolean, 
    /**
     * name of local storage location
     */
    storageKey?: 'localStorage' | 'sessionStorage');
    setup(config: IStorageConfig): void;
    /**
     * Encrypts an item
     * @param data Item
     * @returns Encrypted Object
     */
    encrypt: (data: any) => string;
    /**
     * Decrypts an encrypted item
     * @param data Encrypted string
     * @returns Decrypted Object
     */
    decrypt: <T = any>(data: string) => T;
    /**
     * Saves an item to the app storage
     * @param key Name of item
     * @param data Item
     * @returns Item
     */
    saveItem: <T>(key: string, data: T) => any;
    /**
     * Saves an item to the app storage asynchronously
     * @param key Name of item
     * @param data Item
     * @returns Item
     */
    saveItemA: <T>(key: string, data: T) => Promise<any>;
    /**
     * Get an item from the app storage
     * @param key name of item
     * @param shouldThrow Whether to throw an error if it is not found
     * @returns Item
     */
    getItem: <T = any>(key: string, shouldThrow?: boolean) => T;
    /**
     * Get an item from the app storage asynchronously
     * @param key name of item
     * @param shouldThrow  Whether to throw an error if it is not found
     * @returns item
     */
    getItemA: <T = any>(key: string, shouldThrow?: boolean) => Promise<T>;
    /**
     * Remove and item from the app storage
     * @param key name of item
     * @returns
     */
    removeItem: (key: string) => void;
    /**
     * Clear the app storage
     * @returns
     */
    clear: () => void | Promise<any>;
}
interface IStorageConfig {
    saveAsyncFunc?: <T>(key: string, data: T) => Promise<any>;
    getAsyncFunc?: <T>(key: string) => Promise<T>;
    removeAsyncFunc: (key: string) => Promise<any>;
    clearAsyncFunc: () => Promise<any>;
    saveFunc?: <T>(key: string, data: T) => any;
    getFunc?: <T>(key: string) => T;
}
export {};
