"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageClass = void 0;
class StorageClass {
    constructor(eS, 
    /**
     * Specify whether it is a production environment
     */
    isProduction, 
    /**
     * name of local storage location
     */
    storageKey = 'localStorage') {
        this.eS = eS;
        this.isProduction = isProduction;
        this.storageKey = storageKey;
        /**
         * Encrypts an item
         * @param data Item
         * @returns Encrypted Object
         */
        this.encrypt = this.eS.encryptItem;
        /**
         * Decrypts an encrypted item
         * @param data Encrypted string
         * @returns Decrypted Object
         */
        this.decrypt = this.eS.decryptItem;
        /**
         * Saves an item to the app storage
         * @param key Name of item
         * @param data Item
         * @returns Item
         */
        this.saveItem = (key, data) => {
            try {
                if (this.customConfig?.saveFunc)
                    return this.customConfig?.saveFunc(key, data);
                else
                    window[this.storageKey].setItem(key, !(data == null || data == undefined)
                        ? this.isProduction
                            ? this.encrypt(data)
                            : JSON.stringify(data)
                        : '');
                return data;
            }
            catch (error) {
                console.error(error);
                if (error?.name == 'QuotaExceededError') {
                    // this.clear();
                    // return this.saveItem(key, data);
                    throw error?.name;
                }
                else {
                    throw error?.name || error;
                }
            }
        };
        /**
         * Saves an item to the app storage asynchronously
         * @param key Name of item
         * @param data Item
         * @returns Item
         */
        this.saveItemA = (key, data) => this.customConfig?.saveAsyncFunc
            ? this.customConfig?.saveAsyncFunc(key, data)
            : new Promise((resolve) => {
                resolve(this.saveItem(key, data));
            });
        /**
         * Get an item from the app storage
         * @param key name of item
         * @param shouldThrow Whether to throw an error if it is not found
         * @returns Item
         */
        this.getItem = (key, shouldThrow = false) => {
            if (!key)
                return null;
            if (this.customConfig?.getFunc)
                return this.customConfig?.getFunc(key);
            else {
                const encryptedRes = window[this.storageKey].getItem(key);
                try {
                    return this.isProduction
                        ? encryptedRes
                            ? this.decrypt(encryptedRes)
                            : null
                        : JSON.parse(encryptedRes);
                }
                catch (e) {
                    console.error(e);
                    this.saveItem('_temp' + key, encryptedRes);
                    this.removeItem(key);
                    if (shouldThrow) {
                        throw new Error('Item not found');
                    }
                    else {
                        return null;
                    }
                }
            }
        };
        /**
         * Get an item from the app storage asynchronously
         * @param key name of item
         * @param shouldThrow  Whether to throw an error if it is not found
         * @returns item
         */
        this.getItemA = (key, shouldThrow = false) => this.customConfig?.getAsyncFunc
            ? this.customConfig?.getAsyncFunc(key)
            : new Promise((resolve, reject) => {
                try {
                    resolve(this.getItem(key, shouldThrow));
                }
                catch (error) {
                    reject(error);
                }
            });
        /**
         * Remove and item from the app storage
         * @param key name of item
         * @returns
         */
        this.removeItem = (key) => {
            if (this.customConfig?.removeAsyncFunc)
                this.customConfig?.removeAsyncFunc(key);
            else
                try {
                    window[this.storageKey].removeItem(key);
                }
                catch (error) { }
        };
        /**
         * Clear the app storage
         * @returns
         */
        this.clear = () => {
            return this.customConfig?.clearAsyncFunc
                ? this.customConfig?.clearAsyncFunc()
                : window[this.storageKey].clear();
        };
    }
    setup(config) {
        this.customConfig = config;
    }
}
exports.StorageClass = StorageClass;
//# sourceMappingURL=storage.class.js.map