/// <reference types="node" />
import { Config } from '../config/index.config';
import jfd from 'js-file-download';
import { Observable } from 'rxjs';
import { EPeriod, EValidationType } from '../shared/models/index.model';
import { EnvironmentClass } from '../shared/classes/environment.class.lite';
export declare class UtilityClass {
    environment: EnvironmentClass;
    downloader: typeof jfd;
    config: typeof Config;
    eValidationType: typeof EValidationType;
    ePeriod: typeof EPeriod;
    constructor(environment: EnvironmentClass);
    imageTypes: {
        [type: string]: boolean;
    };
    /**
     * Uses a web worker to perform a task
     * @example new Worker(new URL('./upload-csv.worker', import.meta.url))
     * @param worker Web worker object
     * @param inputData Data being passed into web worker
     * @returns Data gotten from web worker
     */
    useWebWorker<T = any>(worker: Worker, inputData: any, conditions?: {
        stop: (res: any) => boolean;
        error: (res: any) => boolean;
    }): Observable<T>;
    /**
     * Converts an array to a key value pair.
     * @param arr Array to be converted
     * @param keyField The field to be used as the key
     * @returns An index object containing the keyField as the index key and each item of the array as value assigned to each index
     */
    arrayToMap<T>(arr: T[], keyField: keyof T): {
        [x: string]: T;
    };
    arrayToMap<T, NT>(arr: T[], keyField: keyof T, map: (item: T) => NT): {
        [x: string]: NT;
    };
    /**
     * Gets all the fields in all the items in an array
     * @param arr
     * @returns The index map of the fields with the fields serving as the index keys. Each entry contains the count of the times that a value was found for the field
     */
    getAllFieldsInArray: <T>(arr: T[]) => {
        [field: string]: {
            field: keyof T;
            count: number;
        };
    };
    sortObjectFields: <T>(obj: T) => T;
    copyString(str: string): Promise<void>;
    copyObject(payload: Object): Promise<void>;
    xOrY: (x: any, y?: string) => string;
    /**
     * Convert Date string to Date Time string
     * @param dateStr Date string
     * @example '2022-01-25'
     * @param config Configuration for the conversion
     * @returns Returns a Date Time string
     * @example '2022-01-25T00:00:00Z' or '2022-01-25 00:00:00'
     */
    dateToDateTime: (dateStr: string, config?: {
        /**
         * Use the yyyy-mm-dd hh:mm:ss format
         */
        omitT?: boolean;
    }) => string;
    /**
     * Set an Object's field if the object exists or don't if the object doesn't
     * @param obj Object holding the field
     * @param fieldName Name of the field to set
     * @param val Value to set the field with
     * @returns Returns the object holding the data
     */
    setterWithNull<T>(obj: T, kvps: Partial<T>): T;
    /**
     * (Set an Object's field if the object exists or don't if the object doesn't) for multiple entries
     * @param items Array of objects and their modifications
     */
    setterWithNullArray<T>(items: {
        obj: T;
        kvps: Partial<T>;
    }[]): void;
    /**
     * Handles the deletion of rows from an array
     * @param index Index of the row to delete
     * @param arr The array that holds the rows
     * @param deleteService The deletion service to be called (It should be an anonymous function)
     * @param addRowFunc The function (anonymous) that adds a new row to the array
     * @param cb The function to callback with the response of the deletion service as the input parameter
     */
    handleRowDelete: <T>(index: number, arr: any[], deleteService: (...args: any[]) => Promise<T> | Observable<T>, addRowFunc: (...args: any[]) => any, cb?: (any: any) => any) => Promise<void>;
    private isPromise;
    isAsync: (func: any) => boolean;
    isObservable: <T>(func: any) => boolean;
    promisifyVal: <T>(val: T | Promise<T> | Observable<T>) => Promise<Awaited<T>>;
    /**
     * @param arr Array of observables to fetch
     * @returns An array of the responses merged together. It emits the merged responses as they are fetched and closes once alll the responses have been fetched
     */
    mergeArrObservables: <T>(arr: {
        $func: Observable<T[]>;
    }[]) => Observable<T[]>;
    removeDuplicate<T>(list: T[], keyField?: string): T[];
    get genRandomID(): string;
    objIsEmpty: (obj: any, exclusionFields?: string[]) => boolean;
    dataGen: <T = any>(keys: string[], length?: number) => T[];
    textGen: () => string;
    trackByCustomID: (index: any, item: any) => any;
    trackByCode(index: number, item: any): any;
    trackByID(index: number, item: any): any;
    findLabelByItem: (item: any, arr: any[], labelField?: string, keyField?: string) => any;
    /**
     * Converts object to query parameters
     * @param parameters Query object
     * @returns
     */
    objectToQueryParams(parameters?: Object): string;
    base64toBlob: (base64Data: string, contentType?: string, sliceSize?: number) => Blob;
    base64toFile: (base64Data: string, fileName?: string, contentType?: string, sliceSize?: number) => File;
    extractUpload(event: any): File[];
    secondsToHourMinSec: (seconds: number) => {
        hours: number;
        mins: number;
        secs: number;
    };
    minutesToDayHourMin: (minutes: number) => {
        days: number;
        hours: number;
        mins: number;
    };
    minutesToDayHourMinStr: (minutes: number) => string;
    minutesToDayHourMinStr2: (minutes: number) => string;
    dayHourMinToHourMinutes: (dys: number, hrs: number, mins: number) => string;
    dayHourMinToMinutes: (dys: number, hrs: number, mins: number) => number;
    hourMinToMinutes: (hrs: number, mins: number) => number;
    hourMinToMinutes2: (hrsMins: string) => number;
    scrollToTop: (timeout?: number) => NodeJS.Timeout;
    cellStatusFormatter: (guide: {
        successVal?: any;
        errorVal?: any;
        inertVal?: any;
    }) => (v: any) => string;
    /**
     *
     * @returns The current date time local that can be used to set the datetime-local input
     */
    getLocalDateTimeNow: () => string;
    /** @returns The current date local that can be used to set the date input */
    localDateNow: () => string;
    dateFormat: (date: any, format?: number) => string;
    toJavaDateString: (isoDateString?: string) => string;
    timeFormat: (time?: any) => string;
    dateFormatter: (date: any) => string;
    daysFormatter: (days: number) => string;
    monthsFormatter: (months: number) => string;
    pluarlizer: (val: number, txt: string, plural?: string) => string;
    decimalToPercentage: (dec: number) => string;
    logForm: (form: any) => void;
    isPictureFormat(fileName: string): boolean;
    objectToArray<T>(obj: any): T[];
    onlyUnique: <T>(value: T, index: number, self: T[]) => boolean;
    /**
     * Delete null or undefined fields from an object
     * @param obj Object to delete from
     * @returns
     */
    deleteNull: <T>(obj: T) => T;
    /**
     * Convert an object into textshowing the field and values
     * @param obj
     * @returns
     */
    objectToText: (obj: any) => string;
    /**
     * Download file from link
     * @param url Link to download file
     * @param filename Name of file including extension
     */
    downloadFromLink(url: string, filename: string): Promise<void>;
    exportHTMLToPDF(content: HTMLElement, fileName: string, config: {
        width?: number;
        height?: number;
        orientation?: 'p' | 'portrait' | 'l' | 'landscape';
    }): Promise<void>;
    exportHTMLToPDFObject(content: HTMLElement, fileName: string, config: {
        width?: number;
        height?: number;
        orientation?: 'p' | 'portrait' | 'l' | 'landscape';
    }): Promise<File>;
    arrayToCSV(data: any[], filename: string, headerMap: {
        f?: string;
        t?: string;
    }[]): void;
    addDaysToDate(days: number, date: Date | string | number): string;
    get genPhoneNumber(): string;
    generateUUID(): string;
}
