"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentClass = void 0;
const index_config_1 = require("../../config/index.config");
const page_loader_class_1 = require("./page-loader.class");
/**
 * Class for the environment object
 */
class EnvironmentClass {
    /**
     * Set the value of the page loader
     */
    set loading(v) {
        if (v)
            this.pageLoader.startPl();
        else
            this.pageLoader.stopPl();
    }
    /**
     *
     * @param production Specify whether it is a production environment
     * @param name Name of the environment
     * @param apiBaseUrl Base url of the server api
     */
    constructor(production, name, apiBaseUrl) {
        this.production = production;
        this.apiBaseUrl = apiBaseUrl;
        /**
         * Defualt app currency
         */
        this.currency = '₦';
        /**
         * name of local storage location
         */
        this.storageKey = 'localStorage';
        /**
         * storage key for user object
         */
        this.userStorageKey = 'user';
        /**
         * storage key for embedded user object
         */
        this.enbeddedUserStorageKey = 'enbedded-user';
        /**
         * storage key for super user object
         */
        this.adminUserStorageKey = 'super-user';
        /**
         * page loader object
         */
        this.pageLoader = new page_loader_class_1.Loader();
        /** API Request timeout period
         *  Enter value in millisecond or Date object
         */
        this.requestTimeout = new Date(index_config_1.Config.TimeStampDay * 365 + Date.now());
        this.embedKey = 'weffwdfuion';
        if (!production)
            this.debug = true;
        this.name = name;
    }
    updateEnvironment(env) {
        Object.assign(this, env);
    }
    /**
     * Whether it is the dev environment or not
     */
    get isDev() {
        return !this.production;
    }
}
exports.EnvironmentClass = EnvironmentClass;
//# sourceMappingURL=environment.class.lite.js.map