"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loader = void 0;
class Loader {
    constructor() {
        this._pageLoaders = [];
    }
    get isLoading() {
        return this._pageLoaders?.length > 0;
    }
    startPl(value = 1) {
        for (let index = 0; index < value; index++) {
            this._pageLoaders.push(1);
        }
        // console.log('length at start',this._pageLoaders.length)
        return this._pageLoaders?.length;
    }
    restartPl() {
        this._pageLoaders = [];
        this.startPl();
    }
    stopPl(value = 1) {
        for (let index = 0; index < value; index++) {
            this._pageLoaders.pop();
        }
        if (!this._pageLoaders?.length && this.onLoaderStopped)
            this.onLoaderStopped();
        // console.log('length at end', this._pageLoaders.length)
        return this._pageLoaders?.length;
    }
    stopAllPls() {
        this._pageLoaders = [];
    }
}
exports.Loader = Loader;
//# sourceMappingURL=page-loader.class.js.map