"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EPageBtnID = exports.MenuItemDivider = exports.MenuItem = void 0;
class MenuItem {
    get _editAccess() {
        console.log(this.editAccess);
        return this.editAccess;
    }
    set _editAccess(value) {
        this.editAccess = value;
        this.toggleEditAllSubMenus();
    }
    get _viewAccess() {
        return this.viewAccess;
    }
    set _viewAccess(value) {
        this.viewAccess = value;
        this.toggleViewAllSubMenus();
    }
    constructor(menuItem, parent) {
        Object.assign(this, menuItem);
        this.labelLowerCase = menuItem?.label?.toLowerCase();
        this.hasSub = !!menuItem?.subs?.length;
        this.isP = true;
        this.parentID = parent?.id;
        // debugger
        this.subs = menuItem?.subs?.map((m) => new MenuItem(m, this));
    }
    toggle() {
        this.disabled = !this.disabled;
    }
    toggleView() {
        this.viewAccess = !this.viewAccess;
        if (this.editAccess)
            this.viewAccess = true;
    }
    toggleCreate() {
        this.editAccess = !this.editAccess;
        if (this.editAccess)
            this.viewAccess = true;
    }
    allowEditAllSubMenus() {
        this.subs?.forEach((x) => x?.allowEditAllSubMenus());
        //debugger;
        this.viewAccess = true;
        this.editAccess = true;
    }
    disableEditAllSubMenus() {
        this.subs?.forEach((x) => x?.disableEditAllSubMenus());
        this.editAccess = false;
    }
    allowViewAllSubMenus() {
        this.subs?.forEach((x) => x?.allowViewAllSubMenus());
        //debugger;
        this.viewAccess = true;
        this.editAccess = false;
    }
    disableViewAllSubMenus() {
        this.subs?.forEach((x) => x?.disableViewAllSubMenus());
        this.viewAccess = false;
        this.editAccess = false;
    }
    toggleEditAllSubMenus() {
        // if (this.editAccess == undefined) return;
        !this.editAccess
            ? this.allowEditAllSubMenus()
            : this.disableEditAllSubMenus();
        console.log(this.subs);
    }
    toggleViewAllSubMenus() {
        // if (this.viewAccess == undefined) return;
        // debugger
        !this.viewAccess
            ? this.allowViewAllSubMenus()
            : this.disableViewAllSubMenus();
        console.log(this.subs);
    }
    allowAuthorization() {
        this.viewAccess = true;
        this.editAccess = true;
    }
    disableAuthorization() {
        this.viewAccess = false;
        this.viewAccess = false;
    }
    toggleAuthorization() {
        this.viewAccess = !this.viewAccess;
        this.editAccess = !this.editAccess;
    }
}
exports.MenuItem = MenuItem;
class MenuItemDivider extends MenuItem {
    constructor() {
        super(null);
        this.isDivider = true;
    }
}
exports.MenuItemDivider = MenuItemDivider;
var EPageBtnID;
(function (EPageBtnID) {
    EPageBtnID["agentCommissions"] = "PAC8";
    EPageBtnID["agentCreditNotes"] = "PACN10";
    EPageBtnID["agentDocuments"] = "PAD2";
    EPageBtnID["agentEndorsements"] = "PAE3";
    EPageBtnID["agentLoan"] = "PAL1";
    EPageBtnID["agentNotes"] = "PAN6";
    EPageBtnID["agentPendingQuotes"] = "PAPQ11";
    EPageBtnID["agentPolicies"] = "PAP7";
    EPageBtnID["agentProduction"] = "PAP9";
    EPageBtnID["agentWebLogIn"] = "PAWL4";
    EPageBtnID["agentWorkflows"] = "PAW5";
    EPageBtnID["agentCalendar"] = "PAC6";
    EPageBtnID["clientCalendar"] = "PCC11";
    EPageBtnID["clientDocuments"] = "PCD12";
    EPageBtnID["clientEndorsements"] = "PCE13";
    EPageBtnID["clientNotes"] = "PCN14";
    EPageBtnID["clientOtherBusiness"] = "PCOB15";
    EPageBtnID["clientPendingPayments"] = "PCPP16";
    EPageBtnID["clientPendingQuotes"] = "PCPQ17";
    EPageBtnID["clientPolicies"] = "PCP18";
    EPageBtnID["clientRelationships"] = "PCR19";
    EPageBtnID["clientUnderwritingEvents"] = "PCUE20";
    EPageBtnID["clientWebLogIn"] = "PCWL21";
    EPageBtnID["clientWorkflows"] = "PCW22";
})(EPageBtnID || (exports.EPageBtnID = EPageBtnID = {}));
//# sourceMappingURL=IMenuItem.js.map