"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuditListResponsesCursorLimitPagination = exports.Audit = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Audit extends resource_1.APIResource {
    /**
     * Gets a list of audit logs for an account. <br /> <br /> This is the beta release
     * of Audit Logs Version 2. Since this is a beta version, there may be gaps or
     * missing entries in the available audit logs. Be aware of the following
     * limitations. <br /> <ul> <li>Audit logs are available only for the past 30 days.
     * <br /></li> <li>Error handling is not yet implemented. <br /> </li> </ul>
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/logs/audit`, AuditListResponsesCursorLimitPagination, { query, ...options });
    }
}
exports.Audit = Audit;
class AuditListResponsesCursorLimitPagination extends pagination_1.CursorLimitPagination {
}
exports.AuditListResponsesCursorLimitPagination = AuditListResponsesCursorLimitPagination;
Audit.AuditListResponsesCursorLimitPagination = AuditListResponsesCursorLimitPagination;
//# sourceMappingURL=audit.js.map