"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.MembersV4PagePaginationArray = exports.Members = void 0;
const resource_1 = require("../../resource.js");
const shared_1 = require("../shared.js");
Object.defineProperty(exports, "MembersV4PagePaginationArray", { enumerable: true, get: function () { return shared_1.MembersV4PagePaginationArray; } });
class Members extends resource_1.APIResource {
    /**
     * Add a user to the list of members for this account.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/members`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Modify an account member.
     */
    update(memberId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/members/${memberId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List all members of an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/members`, shared_1.MembersV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Remove a member from an account.
     */
    delete(memberId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/members/${memberId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get information about a specific member of an account.
     */
    get(memberId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/members/${memberId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Members = Members;
//# sourceMappingURL=members.js.map