// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { RolesV4PagePaginationArray } from "../shared.mjs";
export class Roles extends APIResource {
    /**
     * Get all available roles for an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/roles`, RolesV4PagePaginationArray, {
            query,
            ...options,
        });
    }
    /**
     * Get information about a specific role for an account.
     */
    get(roleId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/roles/${roleId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export { RolesV4PagePaginationArray };
//# sourceMappingURL=roles.mjs.map